/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Sigmoid(DensityFunction arg) implements DensityFunction
{
    private static final MapCodec<Sigmoid> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Sigmoid::arg)).apply((Applicative)instance, Sigmoid::new));
    public static final TypedCodec<Sigmoid> TYPED_CODEC = new TypedCodec("sigmoid", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double density) {
        return 1.0 / (1.0 + StrictMath.exp(-density));
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return Sigmoid.eval(this.arg.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Sigmoid(this.arg.mapAll(visitor)));
    }

    public double minValue() {
        return Sigmoid.eval(this.arg.minValue());
    }

    public double maxValue() {
        return Sigmoid.eval(this.arg.maxValue());
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

