/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.zip.InflaterInputStream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record SingleChannelImageTessellation(int xSize, int zSize, byte[] inflatedFrameData) implements DensityFunction
{
    private static final MapCodec<SingleChannelImageTessellation> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("x_size").forGetter(SingleChannelImageTessellation::xSize), (App)ExtraCodecs.POSITIVE_INT.fieldOf("z_size").forGetter(SingleChannelImageTessellation::zSize), (App)ExtraCodecs.BASE64_STRING.fieldOf("deflated_frame_data").forGetter(SingleChannelImageTessellation::inflatedFrameData)).apply((Applicative)instance, SingleChannelImageTessellation::create));
    public static final TypedCodec<SingleChannelImageTessellation> TYPED_CODEC = new TypedCodec("single_channel_image_tessellation", KeyDispatchDataCodec.of(MAP_CODEC));

    private static SingleChannelImageTessellation create(int xSize, int zSize, byte[] deflatedFrameData) {
        byte[] inflatedBytes;
        try {
            InflaterInputStream inflaterStream = new InflaterInputStream(new ByteArrayInputStream(deflatedFrameData));
            inflatedBytes = inflaterStream.readAllBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error: More Density Functions failed to decompress frame data", e);
        }
        return new SingleChannelImageTessellation(xSize, zSize, inflatedBytes);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        int x = pos.blockX();
        int z = pos.blockZ();
        int arrayPos = StrictMath.floorMod(x, this.xSize) + StrictMath.floorMod(z, this.zSize) * this.xSize;
        return this.inflatedFrameData[arrayPos] & 0xFF;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new SingleChannelImageTessellation(this.xSize, this.zSize, this.inflatedFrameData));
    }

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return 255.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

