/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record SquareRoot(DensityFunction arg) implements DensityFunction
{
    private static final MapCodec<SquareRoot> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(SquareRoot::arg)).apply((Applicative)instance, SquareRoot::new));
    public static final TypedCodec<SquareRoot> TYPED_CODEC = new TypedCodec("sqrt", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double density) {
        return StrictMath.sqrt(density);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return SquareRoot.eval(this.arg.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new SquareRoot(this.arg.mapAll(visitor)));
    }

    public double minValue() {
        double domainMinLocation = 0.0;
        double argMin = this.arg.minValue();
        if (argMin > domainMinLocation) {
            return SquareRoot.eval(argMin);
        }
        double argMax = this.arg.maxValue();
        if (argMax < domainMinLocation) {
            return Double.NaN;
        }
        return 0.0;
    }

    public double maxValue() {
        return SquareRoot.eval(this.arg.maxValue());
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

