/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.MoreDensityFunctionsConstants;
import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record ZClampedGradient(int fromZ, int toZ, double fromValue, double toValue) implements DensityFunction
{
    private static final MapCodec<ZClampedGradient> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MoreDensityFunctionsConstants.COORD_CODEC_INT.fieldOf("from_z").forGetter(ZClampedGradient::fromZ), (App)MoreDensityFunctionsConstants.COORD_CODEC_INT.fieldOf("to_z").forGetter(ZClampedGradient::toZ), (App)Codec.doubleRange((double)-1000000.0, (double)1000000.0).fieldOf("from_value").forGetter(ZClampedGradient::fromValue), (App)Codec.doubleRange((double)-1000000.0, (double)1000000.0).fieldOf("to_value").forGetter(ZClampedGradient::toValue)).apply((Applicative)instance, ZClampedGradient::new));
    public static final TypedCodec<ZClampedGradient> TYPED_CODEC = new TypedCodec("z_clamped_gradient", KeyDispatchDataCodec.of(MAP_CODEC));

    public double compute(DensityFunction.FunctionContext pos) {
        return Mth.clampedMap((double)pos.blockZ(), (double)this.fromZ, (double)this.toZ, (double)this.fromValue, (double)this.toValue);
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new ZClampedGradient(this.fromZ, this.toZ, this.fromValue, this.toValue));
    }

    public double minValue() {
        return StrictMath.min(this.fromValue, this.toValue);
    }

    public double maxValue() {
        return StrictMath.max(this.fromValue, this.toValue);
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

