/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.randomsamplers;

import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodecRegistry;
import com.mojang.serialization.Codec;

public interface RandomSampler {
    public static final AnonymousTypedCodecRegistry<RandomSampler> REGISTRY = new AnonymousTypedCodecRegistry("RandomSampler");
    public static final Codec<RandomSampler> CODEC = REGISTRY.createDispatchCodec(randomSampler -> randomSampler.anonCodec().type());

    public AnonymousTypedCodec<? extends RandomSampler> anonCodec();

    public double sample(long var1);

    public double minValue();

    public double maxValue();

    public static long hashPosition(int x, int y, int z, int salt) {
        long xy = (long)x << 32 | ((long)y & 0xFFFFFFFFL) + 31L;
        long zsalt = (long)z << 32 | ((long)salt & 0xFFFFFFFFL) + 1337L;
        long seed = WorldSeedHolder.worldSeed;
        seed ^= xy * 5490034563487805519L;
        seed ^= zsalt * 8951897656766556691L;
        seed *= 6019079666967813221L;
        seed ^= seed << 19;
        return seed;
    }

    public static long mix(long seed) {
        seed = seed * 6364136223846793005L + 1442695040888963407L;
        long finalSeed = (seed >>> (int)(seed >>> 59) + 5 ^ seed) * -4132994306676758123L;
        return finalSeed >>> 43 ^ finalSeed;
    }

    public static double sampleDouble(long seed) {
        return (double)(seed >>> 11) * (double)1.110223E-16f;
    }

    public static int sampleInt(long seed, int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long x = seed >>> 32 & 0xFFFFFFFFL;
        long m = x * (long)bound;
        long l = m & 0xFFFFFFFFL;
        if (l < (long)bound) {
            long t = 0x100000000L % (long)bound;
            while (l < t) {
                seed = RandomSampler.mix(seed);
                x = seed >>> 32 & 0xFFFFFFFFL;
                m = x * (long)bound;
                l = m & 0xFFFFFFFFL;
            }
        }
        return (int)(m >>> 32);
    }

    public static double sampleGaussian(long seed) {
        double u1 = RandomSampler.sampleDouble(seed);
        double u2 = RandomSampler.sampleDouble(RandomSampler.mix(seed));
        if (u1 < 1.0E-15) {
            u1 = 1.0E-15;
        }
        return StrictMath.sqrt(-2.0 * StrictMath.log(u1)) * StrictMath.cos(Math.PI * 2 * u2);
    }

    public static class WorldSeedHolder {
        static volatile long worldSeed;

        public static void setWorldSeed(long seed) {
            worldSeed = seed;
        }
    }
}

