/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.randomsamplers;

import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record UniformSampler(double min, double max, double range) implements RandomSampler
{
    private static final MapCodec<UniformSampler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)-1.7976931348623157E308, (double)Double.MAX_VALUE).fieldOf("min").forGetter(UniformSampler::min), (App)Codec.doubleRange((double)-1.7976931348623157E308, (double)Double.MAX_VALUE).fieldOf("max").forGetter(UniformSampler::max)).apply((Applicative)instance, UniformSampler::create));
    public static final AnonymousTypedCodec<UniformSampler> ANON_CODEC = new AnonymousTypedCodec<UniformSampler>("uniform", CODEC);

    public static UniformSampler create(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("Min must be less than max! min: " + min + " max: " + max);
        }
        double range = max - min;
        return new UniformSampler(min, max, range);
    }

    @Override
    public double sample(long hashedSeed) {
        return this.min + this.range * RandomSampler.sampleDouble(hashedSeed);
    }

    @Override
    public double minValue() {
        return this.min;
    }

    @Override
    public double maxValue() {
        return this.max;
    }

    @Override
    public AnonymousTypedCodec<? extends RandomSampler> anonCodec() {
        return ANON_CODEC;
    }
}

