/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.MoreDensityFunctionsConstants;
import com.klinbee.moredensityfunctions.distancemetrics.DistanceMetric;
import com.klinbee.moredensityfunctions.distancemetrics.Linear;
import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_7243;

public record Distance(DistanceMetric distanceMetric, class_6910[] point1, class_6910[] point2) implements class_6910
{
    private static final MapCodec<Distance> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DistanceMetric.CODEC.fieldOf("distance_metric").forGetter(Distance::distanceMetric), (App)MoreDensityFunctionsConstants.DENSITY_FUNCTION_ARRAY_CODEC.fieldOf("point1").forGetter(Distance::point1), (App)MoreDensityFunctionsConstants.DENSITY_FUNCTION_ARRAY_CODEC.fieldOf("point2").forGetter(Distance::point2)).apply((Applicative)instance, Distance::create));
    public static final TypedCodec<Distance> TYPED_CODEC = new TypedCodec("distance", class_7243.method_42116(MAP_CODEC));

    private static Distance create(DistanceMetric distanceMetric, class_6910[] point1, class_6910[] point2) {
        if (point1.length == 0 && point2.length == 0) {
            throw new IllegalArgumentException("Distance points' dimension must be above 0!");
        }
        if (point1.length == 0) {
            point1 = new class_6910[point2.length];
            Arrays.fill(point1, class_6916.method_40480((double)0.0));
        }
        if (point2.length == 0) {
            point2 = new class_6910[point1.length];
            Arrays.fill(point2, class_6916.method_40480((double)0.0));
        }
        if (point1.length != point2.length) {
            throw new IllegalArgumentException("Distance points must have the same dimension!");
        }
        if (point1.length == 1) {
            return new Distance(new Linear(), point1, point2);
        }
        return new Distance(distanceMetric, point1, point2);
    }

    public double method_40464(class_6910.class_6912 pos) {
        double[] values1 = new double[this.point1.length];
        double[] values2 = new double[this.point2.length];
        for (int i = 0; i < this.point1.length; ++i) {
            values1[i] = this.point1[i].method_40464(pos);
            values2[i] = this.point2[i].method_40464(pos);
        }
        return this.distanceMetric.distance(values1, values2);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        for (int i = 0; i < this.point1.length; ++i) {
            this.point1[i].method_40469(visitor);
            this.point2[i].method_40469(visitor);
        }
        return visitor.apply((class_6910)new Distance(this.distanceMetric, this.point1, this.point2));
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    private double[] minAbsDiffs() {
        double[] minAbsDiffs = new double[this.point1.length];
        for (int i = 0; i < this.point1.length; ++i) {
            double p1Min = this.point1[i].comp_377();
            double p1Max = this.point1[i].comp_378();
            double p2Min = this.point2[i].comp_377();
            double p2Max = this.point2[i].comp_378();
            double diffMin = p2Min - p1Max;
            double diffMax = p2Max - p1Min;
            minAbsDiffs[i] = diffMin <= 0.0 && diffMax >= 0.0 ? 0.0 : StrictMath.min(StrictMath.abs(diffMin), StrictMath.abs(diffMax));
        }
        return minAbsDiffs;
    }

    private double[] maxAbsDiffs() {
        double[] maxAbsDiffs = new double[this.point1.length];
        for (int i = 0; i < this.point1.length; ++i) {
            double p1Min = this.point1[i].comp_377();
            double p1Max = this.point1[i].comp_378();
            double p2Min = this.point2[i].comp_377();
            double p2Max = this.point2[i].comp_378();
            double diffMin = p2Min - p1Max;
            double diffMax = p2Max - p1Min;
            maxAbsDiffs[i] = StrictMath.max(StrictMath.abs(diffMin), StrictMath.abs(diffMax));
        }
        return maxAbsDiffs;
    }

    public double comp_377() {
        return this.distanceMetric.minValue(this.minAbsDiffs());
    }

    public double comp_378() {
        return this.distanceMetric.maxValue(this.maxAbsDiffs());
    }

    public class_7243<? extends class_6910> method_41062() {
        return TYPED_CODEC.codec();
    }
}

