/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.distancemetrics;

import com.klinbee.moredensityfunctions.distancemetrics.DistanceMetric;
import com.klinbee.moredensityfunctions.distancemetrics.Euclidean;
import com.klinbee.moredensityfunctions.distancemetrics.Manhattan;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record Minkowski(int p) implements DistanceMetric
{
    public static final MapCodec<DistanceMetric> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("p").forGetter(m -> ((Minkowski)m).p)).apply((Applicative)instance, Minkowski::create));
    public static final AnonymousTypedCodec<DistanceMetric> ANON_CODEC = new AnonymousTypedCodec<DistanceMetric>("minkowski", CODEC);

    private static DistanceMetric create(int p) {
        return switch (p) {
            case 0 -> new Manhattan();
            case 1 -> new Euclidean();
            default -> new Minkowski(p);
        };
    }

    @Override
    public double distance(double[] point1, double[] point2) {
        double sum = 0.0;
        for (int i = 0; i < point1.length; ++i) {
            sum += StrictMath.pow(StrictMath.abs(point2[i] - point1[i]), this.p);
        }
        return StrictMath.pow(sum, 1.0 / (double)this.p);
    }

    @Override
    public double minValue(double[] minAbsDiffs) {
        double sum = 0.0;
        for (double diff : minAbsDiffs) {
            sum += StrictMath.pow(diff, this.p);
        }
        return StrictMath.pow(sum, 1.0 / (double)this.p);
    }

    @Override
    public double maxValue(double[] maxAbsDiffs) {
        double sum = 0.0;
        for (double diff : maxAbsDiffs) {
            sum += StrictMath.pow(diff, this.p);
        }
        return StrictMath.pow(sum, 1.0 / (double)this.p);
    }

    @Override
    public AnonymousTypedCodec<? extends DistanceMetric> anonCodec() {
        return ANON_CODEC;
    }
}

