/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.MoreDensityFunctionsConstants;
import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_5699;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_7243;

public record GappedGridSquareSpiral(int xSize, int zSize, int spacing, class_6910[] gridCellArgs, class_6910 oobArg) implements class_6910
{
    private static final MapCodec<GappedGridSquareSpiral> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33442.fieldOf("x_size").forGetter(GappedGridSquareSpiral::xSize), (App)class_5699.field_33442.fieldOf("z_size").forGetter(GappedGridSquareSpiral::zSize), (App)class_5699.field_33442.fieldOf("spacing").orElse((Object)1).forGetter(GappedGridSquareSpiral::spacing), (App)MoreDensityFunctionsConstants.DENSITY_FUNCTION_ARRAY_CODEC.fieldOf("grid_cell_args").forGetter(GappedGridSquareSpiral::gridCellArgs), (App)class_6910.field_37059.fieldOf("out_of_bounds_argument").orElse((Object)class_6916.method_40480((double)-1.0)).forGetter(GappedGridSquareSpiral::oobArg)).apply((Applicative)instance, GappedGridSquareSpiral::create));
    public static final TypedCodec<GappedGridSquareSpiral> TYPED_CODEC = new TypedCodec("gapped_grid_square_spiral", class_7243.method_42116(MAP_CODEC));

    private static GappedGridSquareSpiral create(int xSize, int zSize, int spacing, class_6910[] gridCellArgs, class_6910 oobArg) {
        return new GappedGridSquareSpiral(xSize, zSize, spacing + 1, gridCellArgs, oobArg);
    }

    public double method_40464(class_6910.class_6912 pos) {
        int numFunctions;
        int gridX = StrictMath.floorDiv(pos.comp_371(), this.xSize);
        int gridZ = StrictMath.floorDiv(pos.comp_373(), this.zSize);
        if (gridX % this.spacing != 0 || gridZ % this.spacing != 0) {
            return this.oobArg.method_40464(pos);
        }
        int normalizedGridX = gridX / this.spacing;
        int normalizedGridZ = gridZ / this.spacing;
        int index = GappedGridSquareSpiral.getSpiralIndex(normalizedGridX, normalizedGridZ);
        if (index >= (numFunctions = this.gridCellArgs.length)) {
            return this.oobArg.method_40464(pos);
        }
        class_6910 arg = this.gridCellArgs[index];
        return arg.method_40464(pos);
    }

    private static int getSpiralIndex(int spiralX, int spiralZ) {
        if (spiralX == 0 && spiralZ == 0) {
            return 0;
        }
        int ring = StrictMath.max(StrictMath.abs(spiralX), StrictMath.abs(spiralZ));
        int index = 1 + 4 * ring * (ring - 1);
        int indexOffset = GappedGridSquareSpiral.getOffsetFromStartIndex(spiralX, spiralZ, ring);
        return index + indexOffset;
    }

    private static int getOffsetFromStartIndex(int spiralX, int spiralZ, int ring) {
        int positionInRing;
        if (spiralX == ring && spiralZ >= -ring && spiralZ < ring) {
            positionInRing = spiralZ + ring;
        } else if (spiralZ == ring && spiralX <= ring && spiralX > -ring) {
            positionInRing = ring * 2 + (ring - spiralX);
        } else if (spiralX == -ring && spiralZ <= ring && spiralZ > -ring) {
            positionInRing = ring * 4 + (ring - spiralZ);
        } else if (spiralZ == -ring && spiralX >= -ring && spiralX < ring) {
            positionInRing = ring * 6 + (spiralX + ring);
        } else {
            throw new IllegalArgumentException("Invalid coordinate (" + spiralX + ", " + spiralZ + ") for spiral");
        }
        return positionInRing;
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new GappedGridSquareSpiral(this.xSize, this.zSize, this.spacing, this.gridCellArgs, this.oobArg.method_40469(visitor)));
    }

    public double comp_377() {
        return StrictMath.min(this.oobArg.comp_377(), 0.0);
    }

    public double comp_378() {
        return StrictMath.max(this.oobArg.comp_378(), 255.0);
    }

    public class_7243<? extends class_6910> method_41062() {
        return TYPED_CODEC.codec();
    }
}

