/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.class_5699;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public record GradientMagnitude(class_6910 arg, int stepX, int stepY, int stepZ) implements class_6910
{
    public static final MapCodec<GradientMagnitude> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6910.field_37059.fieldOf("argument").forGetter(GradientMagnitude::arg), (App)class_5699.field_33441.fieldOf("step_x").orElse((Object)0).forGetter(GradientMagnitude::stepX), (App)class_5699.field_33441.fieldOf("step_y").orElse((Object)0).forGetter(GradientMagnitude::stepY), (App)class_5699.field_33441.fieldOf("step_z").orElse((Object)0).forGetter(GradientMagnitude::stepZ)).apply((Applicative)instance, GradientMagnitude::create));
    public static final TypedCodec<GradientMagnitude> TYPED_CODEC = new TypedCodec("gradient_magnitude", class_7243.method_42116(MAP_CODEC));

    private static GradientMagnitude create(class_6910 arg, int stepX, int stepY, int stepZ) {
        if ((stepX | stepY | stepZ) == 0) {
            throw new IllegalArgumentException("Gradient Magnitude must contain at least one non-zero step component!");
        }
        return new GradientMagnitude(arg, stepX, stepY, stepZ);
    }

    public double method_40464(class_6910.class_6912 pos) {
        int x = pos.comp_371();
        int y = pos.comp_372();
        int z = pos.comp_373();
        double gradX = 0.0;
        double gradY = 0.0;
        double gradZ = 0.0;
        if (this.stepX != 0) {
            gradX = (this.arg.method_40464((class_6910.class_6912)new BlockContext(x + this.stepX, y, z)) - this.arg.method_40464((class_6910.class_6912)new BlockContext(x - this.stepX, y, z))) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            gradY = (this.arg.method_40464((class_6910.class_6912)new BlockContext(x, y + this.stepY, z)) - this.arg.method_40464((class_6910.class_6912)new BlockContext(x, y - this.stepY, z))) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            gradZ = (this.arg.method_40464((class_6910.class_6912)new BlockContext(x, y, z + this.stepZ)) - this.arg.method_40464((class_6910.class_6912)new BlockContext(x, y, z - this.stepZ))) / (2.0 * (double)this.stepZ);
        }
        if (this.stepY == 0 && this.stepZ == 0) {
            return StrictMath.abs(gradX);
        }
        if (this.stepX == 0 && this.stepZ == 0) {
            return StrictMath.abs(gradY);
        }
        if (this.stepX == 0 && this.stepY == 0) {
            return StrictMath.abs(gradZ);
        }
        return StrictMath.sqrt(gradX * gradX + gradY * gradY + gradZ * gradZ);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new GradientMagnitude(this.arg.method_40469(visitor), this.stepX, this.stepY, this.stepZ));
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public double comp_377() {
        double minGradX = 0.0;
        double minGradY = 0.0;
        double minGradZ = 0.0;
        if (this.stepX != 0) {
            minGradX = (this.arg.comp_377() - this.arg.comp_378()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            minGradY = (this.arg.comp_377() - this.arg.comp_378()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            minGradZ = (this.arg.comp_377() - this.arg.comp_378()) / (2.0 * (double)this.stepZ);
        }
        return minGradX * minGradX + minGradY * minGradY + minGradZ * minGradZ;
    }

    public double comp_378() {
        double maxGradX = 0.0;
        double maxGradY = 0.0;
        double maxGradZ = 0.0;
        if (this.stepX != 0) {
            maxGradX = (this.arg.comp_378() - this.arg.comp_377()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            maxGradY = (this.arg.comp_378() - this.arg.comp_377()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            maxGradZ = (this.arg.comp_378() - this.arg.comp_377()) / (2.0 * (double)this.stepZ);
        }
        return maxGradX * maxGradX + maxGradY * maxGradY + maxGradZ * maxGradZ;
    }

    public class_7243<? extends class_6910> method_41062() {
        return TYPED_CODEC.codec();
    }

    private static final class BlockContext
    extends Record
    implements class_6910.class_6912 {
        private final int blockX;
        private final int blockY;
        private final int blockZ;

        private BlockContext(int blockX, int blockY, int blockZ) {
            this.blockX = blockX;
            this.blockY = blockY;
            this.blockZ = blockZ;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this, o);
        }

        public int comp_371() {
            return this.blockX;
        }

        public int comp_372() {
            return this.blockY;
        }

        public int comp_373() {
            return this.blockZ;
        }
    }
}

