/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record Derivative(DensityFunction arg, DerivativeComponent componentX, DerivativeComponent componentY, DerivativeComponent componentZ) implements DensityFunction
{
    private static final MapCodec<Derivative> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Derivative::arg), (App)DerivativeComponent.CODEC.fieldOf("component_x").orElse((Object)DerivativeComponent.NONE).forGetter(Derivative::componentX), (App)DerivativeComponent.CODEC.fieldOf("component_y").orElse((Object)DerivativeComponent.NONE).forGetter(Derivative::componentY), (App)DerivativeComponent.CODEC.fieldOf("component_z").orElse((Object)DerivativeComponent.NONE).forGetter(Derivative::componentZ)).apply((Applicative)instance, Derivative::create));
    public static final TypedCodec<Derivative> TYPED_CODEC = new TypedCodec("derivative", KeyDispatchDataCodec.of(MAP_CODEC));

    private static Derivative create(DensityFunction arg, DerivativeComponent componentX, DerivativeComponent componentY, DerivativeComponent componentZ) {
        if ((componentX.step | componentY.step | componentZ.step) == 0) {
            throw new IllegalArgumentException("Derivative must contain at least one non-trivial directional component!");
        }
        return new Derivative(arg, componentX, componentY, componentZ);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        int x = pos.blockX();
        int y = pos.blockY();
        int z = pos.blockZ();
        double dirX = 0.0;
        double dirY = 0.0;
        double dirZ = 0.0;
        double gradX = 0.0;
        double gradY = 0.0;
        double gradZ = 0.0;
        if (this.componentX.step != 0) {
            dirX = this.componentX.direction.compute(pos);
            gradX = (this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x + this.componentX.step, y, z)) - this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x - this.componentX.step, y, z))) / (2.0 * (double)this.componentX.step);
        }
        if (this.componentY.step != 0) {
            dirY = this.componentY.direction.compute(pos);
            gradY = (this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x, y + this.componentY.step, z)) - this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x, y - this.componentY.step, z))) / (2.0 * (double)this.componentY.step);
        }
        if (this.componentZ.step != 0) {
            dirZ = this.componentZ.direction.compute(pos);
            gradZ = (this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x, y, z + this.componentZ.step)) - this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x, y, z - this.componentZ.step))) / (2.0 * (double)this.componentZ.step);
        }
        if (this.componentY.step == 0 && this.componentZ.step == 0) {
            return StrictMath.signum(dirX) * gradX;
        }
        if (this.componentX.step == 0 && this.componentZ.step == 0) {
            return StrictMath.signum(dirY) * gradY;
        }
        if (this.componentX.step == 0 && this.componentY.step == 0) {
            return StrictMath.signum(dirZ) * gradZ;
        }
        double magnitude = StrictMath.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        return magnitude == 0.0 ? 0.0 : (dirX * gradX + dirY * gradY + dirZ * gradZ) / magnitude;
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        this.componentX.direction.mapAll(visitor);
        this.componentY.direction.mapAll(visitor);
        this.componentZ.direction.mapAll(visitor);
        return visitor.apply((DensityFunction)new Derivative(this.arg.mapAll(visitor), this.componentX, this.componentY, this.componentZ));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public double minValue() {
        return -1.7976931348623157E308;
    }

    public double maxValue() {
        return Double.MAX_VALUE;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }

    private record DerivativeComponent(int step, DensityFunction direction) {
        static final Codec<DerivativeComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("step").forGetter(DerivativeComponent::step), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("direction").forGetter(DerivativeComponent::direction)).apply((Applicative)instance, DerivativeComponent::new));
        static final DerivativeComponent NONE = new DerivativeComponent(0, DensityFunctions.constant((double)0.0));
    }

    private record BlockContext(int blockX, int blockY, int blockZ) implements DensityFunction.FunctionContext
    {
    }
}

