/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record FloorDivide(DensityFunction numerator, DensityFunction denominator) implements DensityFunction
{
    private static final MapCodec<FloorDivide> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("numerator").forGetter(FloorDivide::numerator), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("denominator").forGetter(FloorDivide::denominator)).apply((Applicative)instance, FloorDivide::new));
    public static final TypedCodec<FloorDivide> TYPED_CODEC = new TypedCodec("floor_div", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double numerator, double denominator) {
        return Mth.floor((double)(numerator / denominator));
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return FloorDivide.eval(this.numerator.compute(pos), this.denominator.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new FloorDivide(this.numerator.mapAll(visitor), this.denominator.mapAll(visitor)));
    }

    public double minValue() {
        double asymptoteLocation = 0.0;
        double denomMin = this.denominator.minValue();
        double denomMax = this.denominator.maxValue();
        double numMin = this.numerator.minValue();
        if (denomMin > asymptoteLocation) {
            return FloorDivide.eval(numMin, denomMax);
        }
        double numMax = this.numerator.maxValue();
        if (denomMax < asymptoteLocation) {
            return FloorDivide.eval(numMax, denomMax);
        }
        return Double.NaN;
    }

    public double maxValue() {
        double asymptoteLocation = 0.0;
        double denomMin = this.denominator.minValue();
        double numMax = this.numerator.maxValue();
        if (denomMin > asymptoteLocation) {
            return FloorDivide.eval(numMax, denomMin);
        }
        double denomMax = this.denominator.maxValue();
        double numMin = this.numerator.minValue();
        if (denomMax < asymptoteLocation) {
            return FloorDivide.eval(numMin, denomMin);
        }
        return Double.NaN;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

