/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record FloorModulo(DensityFunction numerator, DensityFunction denominator) implements DensityFunction
{
    private static final MapCodec<FloorModulo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("numerator").forGetter(FloorModulo::numerator), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("denominator").forGetter(FloorModulo::denominator)).apply((Applicative)instance, FloorModulo::new));
    public static final TypedCodec<FloorModulo> TYPED_CODEC = new TypedCodec("floor_mod", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double numerator, double denominator) {
        return Mth.floor((double)((numerator % denominator + denominator) % denominator));
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return FloorModulo.eval(this.numerator.compute(pos), this.denominator.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new FloorModulo(this.numerator.mapAll(visitor), this.denominator.mapAll(visitor)));
    }

    public double minValue() {
        return StrictMath.min(0.0, (double)Mth.floor((double)Math.nextUp(this.denominator.minValue())));
    }

    public double maxValue() {
        return StrictMath.max(0.0, (double)Mth.floor((double)Math.nextDown(this.denominator.maxValue())));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

