/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record Resolver(DensityFunction arg) implements DensityFunction
{
    private static final MapCodec<Resolver> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Resolver::arg)).apply((Applicative)instance, Resolver::new));
    public static final TypedCodec<Resolver> TYPED_CODEC = new TypedCodec("resolver", KeyDispatchDataCodec.of(MAP_CODEC));
    private static final Map<DensityFunction, DensityFunction> RESOLUTION_CACHE = Collections.synchronizedMap(new IdentityHashMap());

    private static DensityFunction unwrapHolder(DensityFunction df) {
        return df instanceof DensityFunctions.HolderHolder ? (DensityFunction)((DensityFunctions.HolderHolder)df).function().value() : df;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return RESOLUTION_CACHE.get(this.arg).compute(pos);
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        DensityFunction visited = RESOLUTION_CACHE.get(this.arg);
        if (visited == null) {
            visited = visitor.apply(this.arg.mapAll(visitor)).mapAll(Resolver::unwrapHolder);
            RESOLUTION_CACHE.put(this.arg, visited);
        }
        return visited;
    }

    public double minValue() {
        return this.arg.minValue();
    }

    public double maxValue() {
        return this.arg.maxValue();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

