/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.class_5699;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_7243;

public record Derivative(class_6910 arg, DerivativeComponent componentX, DerivativeComponent componentY, DerivativeComponent componentZ) implements class_6910
{
    private static final MapCodec<Derivative> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6910.field_37059.fieldOf("argument").forGetter(Derivative::arg), (App)DerivativeComponent.CODEC.fieldOf("component_x").orElse((Object)DerivativeComponent.NONE).forGetter(Derivative::componentX), (App)DerivativeComponent.CODEC.fieldOf("component_y").orElse((Object)DerivativeComponent.NONE).forGetter(Derivative::componentY), (App)DerivativeComponent.CODEC.fieldOf("component_z").orElse((Object)DerivativeComponent.NONE).forGetter(Derivative::componentZ)).apply((Applicative)instance, Derivative::create));
    public static final TypedCodec<Derivative> TYPED_CODEC = new TypedCodec("derivative", class_7243.method_42116(MAP_CODEC));

    private static Derivative create(class_6910 arg, DerivativeComponent componentX, DerivativeComponent componentY, DerivativeComponent componentZ) {
        if ((componentX.step | componentY.step | componentZ.step) == 0) {
            throw new IllegalArgumentException("Derivative must contain at least one non-trivial directional component!");
        }
        return new Derivative(arg, componentX, componentY, componentZ);
    }

    public double method_40464(class_6910.class_6912 pos) {
        int x = pos.comp_371();
        int y = pos.comp_372();
        int z = pos.comp_373();
        double dirX = 0.0;
        double dirY = 0.0;
        double dirZ = 0.0;
        double gradX = 0.0;
        double gradY = 0.0;
        double gradZ = 0.0;
        if (this.componentX.step != 0) {
            dirX = this.componentX.direction.method_40464(pos);
            gradX = (this.arg.method_40464((class_6910.class_6912)new BlockContext(x + this.componentX.step, y, z)) - this.arg.method_40464((class_6910.class_6912)new BlockContext(x - this.componentX.step, y, z))) / (2.0 * (double)this.componentX.step);
        }
        if (this.componentY.step != 0) {
            dirY = this.componentY.direction.method_40464(pos);
            gradY = (this.arg.method_40464((class_6910.class_6912)new BlockContext(x, y + this.componentY.step, z)) - this.arg.method_40464((class_6910.class_6912)new BlockContext(x, y - this.componentY.step, z))) / (2.0 * (double)this.componentY.step);
        }
        if (this.componentZ.step != 0) {
            dirZ = this.componentZ.direction.method_40464(pos);
            gradZ = (this.arg.method_40464((class_6910.class_6912)new BlockContext(x, y, z + this.componentZ.step)) - this.arg.method_40464((class_6910.class_6912)new BlockContext(x, y, z - this.componentZ.step))) / (2.0 * (double)this.componentZ.step);
        }
        if (this.componentY.step == 0 && this.componentZ.step == 0) {
            return StrictMath.signum(dirX) * gradX;
        }
        if (this.componentX.step == 0 && this.componentZ.step == 0) {
            return StrictMath.signum(dirY) * gradY;
        }
        if (this.componentX.step == 0 && this.componentY.step == 0) {
            return StrictMath.signum(dirZ) * gradZ;
        }
        double magnitude = StrictMath.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        return magnitude == 0.0 ? 0.0 : (dirX * gradX + dirY * gradY + dirZ * gradZ) / magnitude;
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        this.componentX.direction.method_40469(visitor);
        this.componentY.direction.method_40469(visitor);
        this.componentZ.direction.method_40469(visitor);
        return visitor.apply((class_6910)new Derivative(this.arg.method_40469(visitor), this.componentX, this.componentY, this.componentZ));
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public double comp_377() {
        return -1.7976931348623157E308;
    }

    public double comp_378() {
        return Double.MAX_VALUE;
    }

    public class_7243<? extends class_6910> method_41062() {
        return TYPED_CODEC.codec();
    }

    private record DerivativeComponent(int step, class_6910 direction) {
        static final Codec<DerivativeComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("step").forGetter(DerivativeComponent::step), (App)class_6910.field_37059.fieldOf("direction").forGetter(DerivativeComponent::direction)).apply((Applicative)instance, DerivativeComponent::new));
        static final DerivativeComponent NONE = new DerivativeComponent(0, class_6916.method_40480((double)0.0));
    }

    private static final class BlockContext
    extends Record
    implements class_6910.class_6912 {
        private final int blockX;
        private final int blockY;
        private final int blockZ;

        private BlockContext(int blockX, int blockY, int blockZ) {
            this.blockX = blockX;
            this.blockY = blockY;
            this.blockZ = blockZ;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this, o);
        }

        public int comp_371() {
            return this.blockX;
        }

        public int comp_372() {
            return this.blockY;
        }

        public int comp_373() {
            return this.blockZ;
        }
    }
}

