/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import net.minecraft.class_5699;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public record Profiler(class_6910 arg, int iterations, int warmUp) implements class_6910
{
    private static final MapCodec<Profiler> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6910.field_37059.fieldOf("argument").forGetter(Profiler::arg), (App)class_5699.field_33441.fieldOf("iterations").forGetter(Profiler::iterations), (App)class_5699.field_33441.fieldOf("warm_up").forGetter(Profiler::warmUp)).apply((Applicative)instance, Profiler::new));
    public static final TypedCodec<Profiler> TYPED_CODEC = new TypedCodec("profiler", class_7243.method_42116(MAP_CODEC));
    private static final Set<class_6910> inactiveProfilers = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    public double method_40464(class_6910.class_6912 pos) {
        int i;
        if (inactiveProfilers.contains(this.arg)) {
            return this.arg.method_40464(pos);
        }
        System.out.println("\nBeginning Profile of Density Function: " + String.valueOf(this.arg));
        long[] warmUpTimes = new long[this.warmUp];
        long[] iterationTimes = new long[this.iterations];
        for (i = 0; i < this.warmUp; ++i) {
            long startWarmUp = System.nanoTime();
            this.arg.method_40464(pos);
            long warmupFinish = System.nanoTime();
            warmUpTimes[i] = warmupFinish - startWarmUp;
        }
        System.gc();
        for (i = 0; i < this.iterations; ++i) {
            long startIteration = System.nanoTime();
            this.arg.method_40464(pos);
            long iterationFinish = System.nanoTime();
            iterationTimes[i] = iterationFinish - startIteration;
        }
        double avgWarmUpTime = Arrays.stream(warmUpTimes).average().orElse(0.0);
        double avgIterationTime = Arrays.stream(iterationTimes).average().orElse(0.0);
        System.out.printf("Profile of %,d iterations:\nAvg. Time per Compute (warm-up stage): %,.3fns\nAvg. Time per Compute (profile stage): %,.3fns\nProfile Time: %,.3fs\n", this.iterations, avgWarmUpTime, avgIterationTime, (avgWarmUpTime * (double)this.warmUp + avgIterationTime * (double)this.iterations) / 1.0E9);
        inactiveProfilers.add(this.arg);
        return this.arg.method_40464(pos);
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        if (!inactiveProfilers.contains(this.arg)) {
            inactiveProfilers.add(this.arg);
            return new Profiler(this.arg.method_40469(visitor), this.iterations, this.warmUp);
        }
        return visitor.apply(this.arg.method_40469(visitor));
    }

    public double comp_377() {
        return this.arg.comp_377();
    }

    public double comp_378() {
        return this.arg.comp_378();
    }

    public class_7243<? extends class_6910> method_41062() {
        return TYPED_CODEC.codec();
    }
}

