/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.densityfunctions.NoiseDensityFunction;
import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public record ValueNoise(RandomSampler randomSampler, int sizeX, int sizeY, int sizeZ, Interpolation interpolation, NoiseDensityFunction.ExtraOctaves extraOctaves, int salt) implements NoiseDensityFunction
{
    private static final MapCodec<ValueNoise> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RandomSampler.CODEC.fieldOf("sampler").forGetter(ValueNoise::randomSampler), (App)class_5699.field_33441.fieldOf("size_x").forGetter(ValueNoise::sizeX), (App)class_5699.field_33441.fieldOf("size_y").forGetter(ValueNoise::sizeY), (App)class_5699.field_33441.fieldOf("size_z").forGetter(ValueNoise::sizeZ), (App)Interpolation.CODEC.fieldOf("interpolation").forGetter(ValueNoise::interpolation), (App)NoiseDensityFunction.ExtraOctaves.CODEC.fieldOf("extra_octaves").orElse((Object)NoiseDensityFunction.ExtraOctaves.getDefault()).forGetter(ValueNoise::extraOctaves), (App)Codec.INT.fieldOf("salt").orElse((Object)0).forGetter(ValueNoise::salt)).apply((Applicative)instance, ValueNoise::new));
    public static final TypedCodec<ValueNoise> TYPED_CODEC = new TypedCodec("value_noise", class_7243.method_42116(MAP_CODEC));

    public ValueNoise(RandomSampler randomSampler, int sizeX, int sizeY, int sizeZ, Interpolation interpolation, NoiseDensityFunction.ExtraOctaves extraOctaves, int salt) {
        this.randomSampler = randomSampler;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.interpolation = interpolation;
        this.extraOctaves = extraOctaves.finalizedWithSalt(salt);
        this.salt = salt;
    }

    @Override
    public double eval(int x, int y, int z) {
        boolean is2D;
        boolean bl = is2D = this.sizeY == 0;
        if (this.interpolation == Interpolation.NONE) {
            return this.computeNoise(x, y, z, this.salt, is2D);
        }
        return this.computeNoiseInterpolated(x, y, z, this.salt, is2D);
    }

    private double computeNoise(int x, int y, int z, int salt, boolean is2D) {
        int gridX = NoiseDensityFunction.safeFloorDiv(x, this.sizeX);
        int gridZ = NoiseDensityFunction.safeFloorDiv(z, this.sizeZ);
        int gridY = is2D ? 0 : NoiseDensityFunction.safeFloorDiv(y, this.sizeY);
        long hash = RandomSampler.hashPosition(gridX, gridY, gridZ, salt);
        return this.randomSampler.sample(hash);
    }

    private double computeNoiseInterpolated(int x, int y, int z, int salt, boolean is2D) {
        return is2D ? this.computeNoiseInterpolated2D(x, z, salt) : this.computeNoiseInterpolated3D(x, y, z, salt);
    }

    private double computeNoiseInterpolated2D(int x, int z, int salt) {
        double cellX = this.calculateCellCoord(x, this.sizeX);
        double cellZ = this.calculateCellCoord(z, this.sizeZ);
        int gridX0 = NoiseDensityFunction.safeFloorDiv(x, this.sizeX);
        int gridZ0 = NoiseDensityFunction.safeFloorDiv(z, this.sizeZ);
        int gridX1 = gridX0 + 1;
        int gridZ1 = gridZ0 + 1;
        double val00 = this.randomSampler.sample(RandomSampler.hashPosition(gridX0, 0, gridZ0, salt));
        double val10 = this.randomSampler.sample(RandomSampler.hashPosition(gridX1, 0, gridZ0, salt));
        double val01 = this.randomSampler.sample(RandomSampler.hashPosition(gridX0, 0, gridZ1, salt));
        double val11 = this.randomSampler.sample(RandomSampler.hashPosition(gridX1, 0, gridZ1, salt));
        double x0 = val00 * (1.0 - cellX) + val10 * cellX;
        double x1 = val01 * (1.0 - cellX) + val11 * cellX;
        return x0 * (1.0 - cellZ) + x1 * cellZ;
    }

    private double computeNoiseInterpolated3D(int x, int y, int z, int salt) {
        double cellX = this.calculateCellCoord(x, this.sizeX);
        double cellY = this.calculateCellCoord(y, this.sizeY);
        double cellZ = this.calculateCellCoord(z, this.sizeZ);
        int gridX0 = NoiseDensityFunction.safeFloorDiv(x, this.sizeX);
        int gridY0 = NoiseDensityFunction.safeFloorDiv(y, this.sizeY);
        int gridZ0 = NoiseDensityFunction.safeFloorDiv(z, this.sizeZ);
        int gridX1 = gridX0 + 1;
        int gridY1 = gridY0 + 1;
        int gridZ1 = gridZ0 + 1;
        double val000 = this.randomSampler.sample(RandomSampler.hashPosition(gridX0, gridY0, gridZ0, salt));
        double val100 = this.randomSampler.sample(RandomSampler.hashPosition(gridX1, gridY0, gridZ0, salt));
        double val010 = this.randomSampler.sample(RandomSampler.hashPosition(gridX0, gridY1, gridZ0, salt));
        double val110 = this.randomSampler.sample(RandomSampler.hashPosition(gridX1, gridY1, gridZ0, salt));
        double val001 = this.randomSampler.sample(RandomSampler.hashPosition(gridX0, gridY0, gridZ1, salt));
        double val101 = this.randomSampler.sample(RandomSampler.hashPosition(gridX1, gridY0, gridZ1, salt));
        double val011 = this.randomSampler.sample(RandomSampler.hashPosition(gridX0, gridY1, gridZ1, salt));
        double val111 = this.randomSampler.sample(RandomSampler.hashPosition(gridX1, gridY1, gridZ1, salt));
        double x00 = val000 * (1.0 - cellX) + val100 * cellX;
        double x10 = val010 * (1.0 - cellX) + val110 * cellX;
        double x01 = val001 * (1.0 - cellX) + val101 * cellX;
        double x11 = val011 * (1.0 - cellX) + val111 * cellX;
        double y0 = x00 * (1.0 - cellY) + x10 * cellY;
        double y1 = x01 * (1.0 - cellY) + x11 * cellY;
        return y0 * (1.0 - cellZ) + y1 * cellZ;
    }

    private double calculateCellCoord(int coord, int size) {
        if (size == 0) {
            return 0.0;
        }
        double cellCoord = (double)StrictMath.floorMod(coord, size) / (double)size;
        if (this.interpolation == Interpolation.SMOOTHSTEP) {
            return cellCoord * cellCoord * (3.0 - 2.0 * cellCoord);
        }
        return cellCoord;
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new ValueNoise(this.randomSampler, this.sizeX, this.sizeY, this.sizeZ, this.interpolation, this.extraOctaves, this.salt));
    }

    public double comp_377() {
        return this.randomSampler.minValue() * this.extraOctaves.maxAmplitude();
    }

    public double comp_378() {
        return this.randomSampler.maxValue() * this.extraOctaves.maxAmplitude();
    }

    public class_7243<? extends class_6910> method_41062() {
        return TYPED_CODEC.codec();
    }

    public static enum Interpolation implements class_3542
    {
        NONE("none"),
        LERP("lerp"),
        SMOOTHSTEP("smoothstep");

        public static final Codec<Interpolation> CODEC;
        private final String name;

        private Interpolation(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Interpolation::values);
        }
    }
}

