/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.randomsamplers;

import com.klinbee.moredensityfunctions.randomsamplers.GammaSampler;
import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record BetaSampler(double alpha, double beta, GammaSampler alphaGen, GammaSampler betaGen) implements RandomSampler
{
    private static final MapCodec<BetaSampler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)Double.MIN_NORMAL, (double)Double.MAX_VALUE).fieldOf("alpha").forGetter(BetaSampler::alpha), (App)Codec.doubleRange((double)Double.MIN_NORMAL, (double)Double.MAX_VALUE).fieldOf("beta").forGetter(BetaSampler::beta)).apply((Applicative)instance, BetaSampler::create));
    public static final AnonymousTypedCodec<BetaSampler> ANON_CODEC = new AnonymousTypedCodec<BetaSampler>("beta", CODEC);

    public static BetaSampler create(double alpha, double beta) {
        return new BetaSampler(alpha, beta, GammaSampler.create(alpha, 1.0), GammaSampler.create(beta, 1.0));
    }

    @Override
    public double sample(long hashedSeed) {
        double x = this.alphaGen.sample(hashedSeed);
        double y = this.betaGen.sample(RandomSampler.mix(hashedSeed + 1L));
        return x / (x + y);
    }

    @Override
    public double minValue() {
        return 0.0;
    }

    @Override
    public double maxValue() {
        return 1.0;
    }

    @Override
    public AnonymousTypedCodec<? extends RandomSampler> anonCodec() {
        return ANON_CODEC;
    }
}

