/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.randomsamplers;

import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record ExponentialSampler(double lambda, double negativeInverseLambda) implements RandomSampler
{
    private static final MapCodec<ExponentialSampler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)Double.MIN_NORMAL, (double)Double.MAX_VALUE).fieldOf("lambda").forGetter(ExponentialSampler::lambda)).apply((Applicative)instance, ExponentialSampler::create));
    public static final AnonymousTypedCodec<ExponentialSampler> ANON_CODEC = new AnonymousTypedCodec<ExponentialSampler>("exponential", CODEC);

    public static ExponentialSampler create(double lambda) {
        double negativeInverseLambda = -1.0 / lambda;
        return new ExponentialSampler(lambda, negativeInverseLambda);
    }

    @Override
    public double sample(long hashedSeed) {
        return this.negativeInverseLambda * StrictMath.log(1.0 - RandomSampler.sampleDouble(hashedSeed));
    }

    @Override
    public double minValue() {
        return 0.0;
    }

    @Override
    public double maxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public AnonymousTypedCodec<? extends RandomSampler> anonCodec() {
        return ANON_CODEC;
    }
}

