/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.randomsamplers;

import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public sealed interface GammaSampler
extends RandomSampler {
    public static final MapCodec<GammaSampler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)Double.MIN_NORMAL, (double)Double.MAX_VALUE).fieldOf("shape").forGetter(GammaSampler::shape), (App)Codec.doubleRange((double)-1.7976931348623157E308, (double)Double.MAX_VALUE).fieldOf("scale").forGetter(GammaSampler::scale)).apply((Applicative)instance, GammaSampler::create));
    public static final AnonymousTypedCodec<GammaSampler> ANON_CODEC = new AnonymousTypedCodec<GammaSampler>("gamma", CODEC);

    public double shape();

    public double scale();

    public static GammaSampler create(double shape, double scale) {
        if (shape < 1.0) {
            double inverseShape = 1.0 / shape;
            return new AhrensDieter(shape, scale, inverseShape);
        }
        double shapeMinusOneThird = shape - 0.3333333333333333;
        double inverseSqrtShape = 1.0 / StrictMath.sqrt(9.0 * shapeMinusOneThird);
        return new MarsagliaTsang(shape, scale, shapeMinusOneThird, inverseSqrtShape);
    }

    @Override
    default public double minValue() {
        return 0.0;
    }

    @Override
    default public double maxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    default public AnonymousTypedCodec<? extends RandomSampler> anonCodec() {
        return ANON_CODEC;
    }

    public record AhrensDieter(double shape, double scale, double inverseShape) implements GammaSampler
    {
        @Override
        public double sample(long hashedSeed) {
            double v;
            double z;
            double u;
            double w;
            double y;
            double x;
            do {
                u = RandomSampler.sampleDouble(hashedSeed);
                hashedSeed = RandomSampler.mix(hashedSeed);
                v = RandomSampler.sampleDouble(hashedSeed);
                hashedSeed = RandomSampler.mix(hashedSeed);
            } while (!((x = this.shape + (y = StrictMath.sqrt(this.inverseShape / (w = u * (1.0 - u))) * (u - 0.5))) >= 0.0) || !((z = 64.0 * w * w * w * v * v) <= 1.0 - 2.0 * y * y / x) && !(StrictMath.log(z) <= 2.0 * (this.shape * StrictMath.log(x / this.shape) - y)));
            return x * this.scale;
        }
    }

    public record MarsagliaTsang(double shape, double scale, double shapeMinusOneThird, double inverseSqrtShape) implements GammaSampler
    {
        @Override
        public double sample(long hashedSeed) {
            double v;
            while (true) {
                double x = RandomSampler.sampleGaussian(hashedSeed);
                hashedSeed = RandomSampler.mix(hashedSeed);
                v = 1.0 + this.inverseSqrtShape * x;
                if (v <= 0.0) continue;
                v = v * v * v;
                double u = RandomSampler.sampleDouble(hashedSeed);
                if (u < 1.0 - 0.0331 * x * x * x * x) {
                    return this.shapeMinusOneThird * v * this.scale;
                }
                if (StrictMath.log(u) < 0.5 * x * x + this.shapeMinusOneThird * (1.0 - v + StrictMath.log(v))) break;
            }
            return this.shapeMinusOneThird * v * this.scale;
        }
    }
}

