/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.voiceServer;

import de.maxhenkel.voicechat.api.BukkitVoicechatService;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.CreateGroupEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.JoinGroupEvent;
import de.maxhenkel.voicechat.api.events.LeaveGroupEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class VoiceServer
extends JavaPlugin
implements VoicechatPlugin,
CommandExecutor,
TabCompleter {
    private static final String COMMAND = "vcgroup";
    private static final List<String> SUBCOMMANDS = List.of("list", "create", "join", "kick", "remove");
    private static final List<String> GROUP_TYPES = List.of("normal", "open", "isolated");
    private static Permission MANAGE_PERMISSION;
    public static Component chatPrefix;
    public static boolean isCracked;
    private VoicechatServerApi serverApi;
    private final Map<UUID, String> groupPasswords = new HashMap<UUID, String>();
    private final Map<UUID, Group> playerGroupMap = new HashMap<UUID, Group>();
    private static final List<String> PERSISTENCE_TYPES;

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(CreateGroupEvent.class, this::onGroupCreatedEvent);
        registration.registerEvent(JoinGroupEvent.class, this::onGroupJoinEvent);
        registration.registerEvent(LeaveGroupEvent.class, this::onGroupLeaveEvent);
    }

    public void onEnable() {
        PluginCommand cmd;
        BukkitVoicechatService service = (BukkitVoicechatService)this.getServer().getServicesManager().load(BukkitVoicechatService.class);
        if (service == null) {
            this.getLogger().warning("[VoiceServer] Voice chat service not found. Plugin disabled.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        service.registerPlugin((VoicechatPlugin)this);
        isCracked = this.isCracked();
        if (isCracked) {
            chatPrefix = ((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"CRAT", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GRAY));
            this.getLogger().info("VoiceServer Plugin enabled with Cracked Attack.");
            MANAGE_PERMISSION = new Permission("voiceserver.vcgroup", PermissionDefault.FALSE);
        } else {
            chatPrefix = ((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"VoiceServer", (TextColor)NamedTextColor.BLUE))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GRAY));
            this.getLogger().info("VoiceServer Plugin enabled.");
            MANAGE_PERMISSION = new Permission("voiceserver.vcgroup", PermissionDefault.OP);
        }
        if (this.getServer().getPluginManager().getPermission(MANAGE_PERMISSION.getName()) == null) {
            this.getServer().getPluginManager().addPermission(MANAGE_PERMISSION);
        }
        if ((cmd = this.getCommand(COMMAND)) != null) {
            cmd.setExecutor((CommandExecutor)this);
            cmd.setTabCompleter((TabCompleter)this);
        }
    }

    private void onGroupCreatedEvent(CreateGroupEvent event) {
        Group group = event.getGroup();
        assert (group != null);
        UUID id = group.getId();
        boolean hasPw = group.hasPassword();
        if (hasPw) {
            this.groupPasswords.put(id, null);
        }
    }

    private void onGroupJoinEvent(JoinGroupEvent event) {
        VoicechatConnection conn = event.getConnection();
        Group group = event.getGroup();
        if (conn == null || group == null) {
            return;
        }
        UUID uuid = conn.getPlayer().getUuid();
        this.playerGroupMap.put(uuid, group);
    }

    private void onGroupLeaveEvent(LeaveGroupEvent event) {
        VoicechatConnection conn = event.getConnection();
        Group group = event.getGroup();
        if (conn == null || group == null) {
            return;
        }
        UUID uuid = conn.getPlayer().getUuid();
        this.playerGroupMap.remove(uuid);
        long remaining = this.playerGroupMap.values().stream().filter(g -> g.getId().equals(group.getId())).count();
        if (remaining == 0L && !group.isPersistent()) {
            this.groupPasswords.remove(group.getId());
            this.serverApi.removeGroup(group.getId());
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (!COMMAND.equalsIgnoreCase(label)) {
            return false;
        }
        if (args.length == 0) {
            this.showUsage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "list": {
                this.listGroups(sender);
                break;
            }
            case "create": {
                this.createGroup(sender, args);
                break;
            }
            case "join": {
                this.joinPlayers(sender, args);
                break;
            }
            case "kick": {
                this.kickPlayers(sender, args);
                break;
            }
            case "remove": {
                this.removeGroup(sender, args);
                break;
            }
            default: {
                this.showUsage(sender);
            }
        }
        return true;
    }

    private void listGroups(CommandSender sender) {
        if (!sender.hasPermission(MANAGE_PERMISSION)) {
            this.sendError(sender, "Permission denied: cannot list groups.");
            return;
        }
        List groups = this.serverApi.getGroups().stream().toList();
        if (groups.isEmpty()) {
            this.sendSuccess(sender, "No voice chat groups available.");
            return;
        }
        this.sendSuccess(sender, "Voice chat groups:");
        for (Group g : groups) {
            boolean isLocked = this.groupPasswords.containsKey(g.getId());
            String displayName = this.quote(g.getName());
            Component clickable = ((TextComponent)((TextComponent)Component.text((String)">> ", (TextColor)NamedTextColor.GRAY).append(((TextComponent)Component.text((String)g.getName(), (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)("/vcgroup join " + sender.getName() + " " + displayName)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Klicke, um der Gruppe beizutreten!", (TextColor)NamedTextColor.GREEN))))).append((Component)Component.text((String)(isLocked ? " [locked]" : ""), (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)(" (" + VoiceServer.typeToString(g.getType()) + ")"), (TextColor)NamedTextColor.GRAY));
            sender.sendMessage(clickable);
        }
    }

    private void createGroup(CommandSender sender, String[] args) {
        Group group;
        if (!sender.hasPermission(MANAGE_PERMISSION)) {
            this.sendError(sender, "Permission denied: cannot create group.");
            return;
        }
        int argLen = args.length;
        if (argLen < 4) {
            this.sendError(sender, "Usage: /vcgroup create <player|@a|@s> <type> \"<group name>\" [persistent] [\"password\"]");
            return;
        }
        List<Player> targets = this.parseTargets(sender, args[1]);
        if (targets.isEmpty()) {
            this.sendError(sender, "No valid players specified.");
            return;
        }
        String typeArg = args[2].toLowerCase(Locale.ROOT);
        Group.Type type = VoiceServer.typeFromString(typeArg);
        int nameIdx = 3;
        String groupName = this.getQuotedArg(args, nameIdx);
        if (groupName == null) {
            this.sendError(sender, "Group name must be in quotes! Beispiel: \"/vcgroup create @s normal \"Hallo Baum\"\"");
            return;
        }
        int nextArgIdx = nameIdx + this.countQuotedArgs(args, nameIdx);
        boolean persistent = false;
        String password = null;
        if (argLen > nextArgIdx) {
            String arg4 = args[nextArgIdx];
            if (arg4.equalsIgnoreCase("persistent")) {
                persistent = true;
                if (argLen > nextArgIdx + 1) {
                    String pw = this.getQuotedArg(args, nextArgIdx + 1);
                    if (pw == null) {
                        this.sendError(sender, "Password must be in quotes if specified! Beispiel: /vcgroup create @s normal \"Gruppe\" persistent \"meinPW\"");
                        return;
                    }
                    password = pw;
                }
            } else if (!arg4.equalsIgnoreCase("not-persistent")) {
                this.sendError(sender, "Password can only be set if persistent is selected.");
                return;
            }
        }
        if (this.findGroup(groupName) != null) {
            this.sendError(sender, "Group already exists: " + groupName);
            return;
        }
        if (persistent) {
            if (password != null && !password.isEmpty()) {
                group = this.serverApi.groupBuilder().setName(groupName).setPersistent(true).setPassword(password).setType(type).build();
                this.groupPasswords.put(group.getId(), password);
                this.sendSuccess(sender, "Group created: " + groupName + " (locked, type=" + typeArg + ", persistent=true)");
            } else {
                group = this.serverApi.groupBuilder().setName(groupName).setPersistent(true).setType(type).build();
                this.sendSuccess(sender, "Group created: " + groupName + " (type=" + typeArg + ", persistent=true)");
            }
        } else {
            group = this.serverApi.groupBuilder().setName(groupName).setPersistent(false).setType(type).build();
            this.sendSuccess(sender, "Group created: " + groupName + " (type=" + typeArg + ", persistent=false)");
        }
        for (Player p : targets) {
            VoicechatConnection conn = this.serverApi.getConnectionOf(p.getUniqueId());
            if (conn == null) {
                this.sendError(sender, "Player not connected to voice chat: " + p.getName());
                continue;
            }
            Group oldGroup = conn.getGroup();
            conn.setGroup(group);
            this.sendSuccess(sender, "Moved player: " + p.getName() + " to group: " + group.getName());
            if (oldGroup == null || oldGroup.getId().equals(group.getId())) continue;
            long remaining = Bukkit.getOnlinePlayers().stream().map(pm -> this.serverApi.getConnectionOf(pm.getUniqueId())).filter(Objects::nonNull).map(VoicechatConnection::getGroup).filter(arg_0 -> ((Group)oldGroup).equals(arg_0)).count();
            if (remaining != 0L || oldGroup.isPersistent()) continue;
            this.serverApi.removeGroup(oldGroup.getId());
            this.groupPasswords.remove(oldGroup.getId());
            this.sendSuccess(sender, "Old group removed (was empty): " + oldGroup.getName());
        }
    }

    private String getQuotedArg(String[] args, int startIdx) {
        if (startIdx >= args.length) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        boolean ended = false;
        for (int i = startIdx; i < args.length; ++i) {
            String arg = args[i];
            if (!started && arg.startsWith("\"")) {
                sb.append(arg.substring(1));
                started = true;
                if (!arg.endsWith("\"") || arg.length() <= 1) continue;
                sb.setLength(sb.length() - 1);
                ended = true;
                break;
            }
            if (!started) continue;
            sb.append(" ");
            if (arg.endsWith("\"")) {
                sb.append(arg, 0, arg.length() - 1);
                ended = true;
                break;
            }
            sb.append(arg);
        }
        return started && ended ? sb.toString() : null;
    }

    private int countQuotedArgs(String[] args, int startIdx) {
        if (startIdx >= args.length) {
            return 0;
        }
        int count = 0;
        boolean started = false;
        boolean ended = false;
        for (int i = startIdx; i < args.length; ++i) {
            String arg = args[i];
            ++count;
            if (!started && arg.startsWith("\"")) {
                started = true;
                if (!arg.endsWith("\"") || arg.length() <= 1) continue;
                ended = true;
                break;
            }
            if (!started || !arg.endsWith("\"")) continue;
            ended = true;
            break;
        }
        return started && ended ? count : 1;
    }

    private void joinPlayers(CommandSender sender, String[] args) {
        if (!sender.hasPermission(MANAGE_PERMISSION)) {
            this.sendError(sender, "Permission denied: cannot join players.");
            return;
        }
        if (args.length < 3) {
            this.sendError(sender, "Usage: /vcgroup join <player|@a|@s> \"<group name>\"");
            return;
        }
        List<Player> targets = this.parseTargets(sender, args[1]);
        String groupName = this.getQuotedArg(args, 2);
        if (groupName == null) {
            this.sendError(sender, "Group name must be in quotes!");
            return;
        }
        Group newGroup = this.findGroup(groupName);
        if (newGroup == null) {
            this.sendError(sender, "Group not found.");
            return;
        }
        for (Player p : targets) {
            VoicechatConnection conn = this.serverApi.getConnectionOf(p.getUniqueId());
            if (conn == null) {
                this.sendError(sender, "Player not connected to voice chat: " + p.getName());
                continue;
            }
            Group oldGroup = conn.getGroup();
            conn.setGroup(newGroup);
            if (oldGroup == null || oldGroup.getId().equals(newGroup.getId())) continue;
            long remaining = Bukkit.getOnlinePlayers().stream().map(pm -> this.serverApi.getConnectionOf(pm.getUniqueId())).filter(Objects::nonNull).map(VoicechatConnection::getGroup).filter(arg_0 -> ((Group)oldGroup).equals(arg_0)).count();
            if (remaining != 0L || oldGroup.isPersistent()) continue;
            this.serverApi.removeGroup(oldGroup.getId());
            this.groupPasswords.remove(oldGroup.getId());
        }
    }

    private void kickPlayers(CommandSender sender, String[] args) {
        if (!sender.hasPermission(MANAGE_PERMISSION)) {
            this.sendError(sender, "Permission denied: cannot kick players.");
            return;
        }
        if (args.length < 2) {
            this.sendError(sender, "Usage: /vcgroup kick <player|@a|@s|@r|@p>");
            return;
        }
        List<Player> targets = this.parseTargets(sender, args[1]);
        if (targets.isEmpty()) {
            this.sendError(sender, "No valid players specified.");
            return;
        }
        for (Player p : targets) {
            VoicechatConnection conn = this.serverApi.getConnectionOf(p.getUniqueId());
            if (conn == null || conn.getGroup() == null) continue;
            Group group = conn.getGroup();
            conn.setGroup(null);
            this.sendSuccess(sender, "Kicked player: " + p.getName() + " from group: " + group.getName());
            long remaining = Bukkit.getOnlinePlayers().stream().map(pm -> this.serverApi.getConnectionOf(pm.getUniqueId())).filter(Objects::nonNull).map(VoicechatConnection::getGroup).filter(arg_0 -> ((Group)group).equals(arg_0)).count();
            if (remaining != 0L || group.isPersistent()) continue;
            this.serverApi.removeGroup(group.getId());
            this.groupPasswords.remove(group.getId());
            this.sendSuccess(sender, "Old group removed (was empty): " + group.getName());
        }
    }

    private void removeGroup(CommandSender sender, String[] args) {
        if (!sender.hasPermission(MANAGE_PERMISSION)) {
            this.sendError(sender, "Permission denied: cannot remove group.");
            return;
        }
        if (args.length < 2) {
            this.sendError(sender, "Usage: /vcgroup remove \"<group name>\"");
            return;
        }
        String groupName = this.getQuotedArg(args, 1);
        if (groupName == null) {
            this.sendError(sender, "Group name must be in quotes!");
            return;
        }
        Group group = this.findGroup(groupName);
        if (group == null) {
            this.sendError(sender, "Group not found.");
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            VoicechatConnection conn = this.serverApi.getConnectionOf(p.getUniqueId());
            if (conn == null || conn.getGroup() == null || !conn.getGroup().getId().equals(group.getId())) continue;
            conn.setGroup(null);
        }
        this.serverApi.removeGroup(group.getId());
        this.groupPasswords.remove(group.getId());
        this.sendSuccess(sender, "Group removed: " + group.getName());
    }

    private List<Player> parseTargets(CommandSender sender, String token) {
        ArrayList<Player> online = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        return switch (token) {
            case "@a" -> online;
            case "@s" -> {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    yield List.of(p);
                }
                yield List.of();
            }
            case "@r" -> {
                if (online.isEmpty()) {
                    yield List.of();
                }
                yield List.of((Player)online.get(new Random().nextInt(online.size())));
            }
            case "@p" -> {
                if (!(sender instanceof Player)) {
                    yield List.of();
                }
                Player ps = (Player)sender;
                Player closest = null;
                double minDist = Double.MAX_VALUE;
                for (Player pl : online) {
                    double dist;
                    if (pl.equals((Object)ps) || !((dist = ps.getLocation().distance(pl.getLocation())) < minDist)) continue;
                    minDist = dist;
                    closest = pl;
                }
                if (closest != null) {
                    yield List.of(closest);
                }
                yield List.of();
            }
            default -> {
                Player p = Bukkit.getPlayerExact((String)token);
                if (p == null) {
                    yield List.of();
                }
                yield List.of(p);
            }
        };
    }

    private Group findGroup(String name) {
        return this.serverApi.getGroups().stream().filter(g -> g.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private void showUsage(CommandSender sender) {
        this.sendSuccess(sender, "Usage: /vcgroup <" + String.join((CharSequence)"|", SUBCOMMANDS) + "> [...] [type]");
    }

    private void sendSuccess(CommandSender sender, String message) {
        sender.sendMessage(chatPrefix.append((Component)Component.text((String)message, (TextColor)NamedTextColor.GRAY)));
    }

    private void sendError(CommandSender sender, String message) {
        sender.sendMessage(chatPrefix.append((Component)Component.text((String)message, (TextColor)NamedTextColor.RED)));
    }

    private void sendPlain(CommandSender sender, String message) {
        sender.sendMessage((Component)Component.text((String)message, (TextColor)NamedTextColor.GRAY));
    }

    public String getPluginId() {
        return "voiceserver";
    }

    public void initialize(VoicechatApi api) {
        VoicechatServerApi s;
        if (!(api instanceof VoicechatServerApi)) {
            throw new IllegalStateException("Expected VoicechatServerApi");
        }
        this.serverApi = s = (VoicechatServerApi)api;
    }

    public static Group.Type typeFromString(@Nullable String type) {
        if (type == null) {
            return Group.Type.NORMAL;
        }
        return switch (type.trim().toLowerCase(Locale.ROOT)) {
            case "open" -> Group.Type.OPEN;
            case "isolated" -> Group.Type.ISOLATED;
            default -> Group.Type.NORMAL;
        };
    }

    public static String typeToString(Group.Type type) {
        if (type == Group.Type.OPEN) {
            return "open";
        }
        if (type == Group.Type.ISOLATED) {
            return "isolated";
        }
        return "normal";
    }

    private boolean isCracked() {
        File pluginsDir = this.getDataFolder().getParentFile();
        File crackFolder = new File(pluginsDir, "CrackedAttack");
        return crackFolder.exists() && crackFolder.isDirectory();
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!COMMAND.equalsIgnoreCase(alias) || !sender.hasPermission(MANAGE_PERMISSION)) {
            return Collections.emptyList();
        }
        List<String> merged = this.mergeQuoted(args);
        ArrayList<String> suggestions = new ArrayList<String>();
        if (merged.isEmpty()) {
            return suggestions;
        }
        String sub = merged.get(0).toLowerCase();
        List<String> quotedGroups = this.serverApi.getGroups().stream().map(Group::getName).map(this::quote).toList();
        switch (merged.size()) {
            case 1: {
                SUBCOMMANDS.stream().filter(sc -> sc.startsWith(sub)).forEach(suggestions::add);
                break;
            }
            case 2: {
                if (List.of("create", "join", "kick").contains(sub)) {
                    suggestions.addAll(List.of("@a", "@s", "@r", "@p"));
                    Bukkit.getOnlinePlayers().forEach(p -> suggestions.add(p.getName()));
                    suggestions.removeIf(n -> !n.toLowerCase().startsWith(((String)merged.get(1)).toLowerCase()));
                    break;
                }
                if (!sub.equals("remove")) break;
                suggestions.addAll(quotedGroups);
                break;
            }
            case 3: {
                if (sub.equals("create")) {
                    for (String type : GROUP_TYPES) {
                        if (!type.startsWith(merged.get(2).toLowerCase())) continue;
                        suggestions.add(type);
                    }
                    break;
                }
                if (!sub.equals("join")) break;
                suggestions.addAll(quotedGroups);
                break;
            }
            case 4: {
                if (!sub.equals("create")) break;
                suggestions.add("\"<group name>\"");
                break;
            }
            case 5: {
                String groupNameArg;
                if (!sub.equals("create") || !(groupNameArg = merged.get(3)).startsWith("\"") || !groupNameArg.endsWith("\"")) break;
                for (String ptype : PERSISTENCE_TYPES) {
                    if (!ptype.startsWith(merged.get(4).toLowerCase())) continue;
                    suggestions.add(ptype);
                }
                break;
            }
            case 6: {
                String persistArg;
                if (!sub.equals("create") || !(persistArg = merged.get(4).toLowerCase()).equals("persistent")) break;
                suggestions.add("\"<password>\"");
                break;
            }
        }
        return suggestions;
    }

    private List<String> mergeQuoted(String[] args) {
        ArrayList<String> merged = new ArrayList<String>();
        StringBuilder current = null;
        for (String arg : args) {
            if (current == null) {
                if (arg.startsWith("\"") && !arg.endsWith("\"")) {
                    current = new StringBuilder(arg);
                    continue;
                }
                merged.add(arg);
                continue;
            }
            current.append(" ").append(arg);
            if (!arg.endsWith("\"")) continue;
            merged.add(current.toString());
            current = null;
        }
        if (current != null) {
            merged.add(current.toString());
        }
        return merged;
    }

    private String quote(String groupName) {
        return "\"" + groupName + "\"";
    }

    static {
        isCracked = false;
        PERSISTENCE_TYPES = List.of("persistent", "not-persistent");
    }
}

