/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.voiceServer.utils;

import de.jakomi1.voiceServer.VoiceServer;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataUtils {
    public static final String CONFIG_NAME = "config.yml";
    public static final String DEFAULT_PREFIX = "\u00a77[\u00a79VS\u00a77]";
    private static FileConfiguration config;
    private static boolean loaded;
    private static boolean isCracked;

    public static boolean isCracked() {
        return isCracked;
    }

    public static void loadConfig() {
        DataUtils.internalLoad();
    }

    public static void reloadConfig() {
        DataUtils.internalLoad();
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void saveConfigFile(File configFile) {
        if (config == null) {
            return;
        }
        try {
            config.save(configFile);
        }
        catch (IOException e) {
            VoiceServer.plugin.getLogger().severe("Failed to save config.yml: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static String getChatPrefix() {
        if (config == null) {
            return DEFAULT_PREFIX;
        }
        String prefix = config.getString("chat-prefix", DEFAULT_PREFIX);
        if (prefix == null || prefix.trim().isEmpty()) {
            prefix = DEFAULT_PREFIX;
            config.set("chat-prefix", (Object)DEFAULT_PREFIX);
            DataUtils.saveConfigFile(new File(VoiceServer.plugin.getDataFolder(), CONFIG_NAME));
        }
        return prefix + " ";
    }

    private static boolean detectCrack() {
        File pluginsDir = VoiceServer.plugin.getDataFolder().getParentFile();
        File crackFolder = new File(pluginsDir, "CrackedAttack");
        return crackFolder.exists() && crackFolder.isDirectory();
    }

    private static void ensureDataFolder(File folder) throws IOException {
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("Could not create plugin data folder: " + folder.getAbsolutePath());
        }
    }

    private static boolean ensureConfigFile(File configFile) {
        boolean created = false;
        if (!configFile.exists()) {
            if (VoiceServer.plugin.getResource(CONFIG_NAME) != null) {
                try {
                    VoiceServer.plugin.saveResource(CONFIG_NAME, false);
                    VoiceServer.plugin.getLogger().info("Default config.yml extracted from plugin jar.");
                }
                catch (Exception e) {
                    VoiceServer.plugin.getLogger().warning("Couldn't extract config.yml from jar: " + e.getMessage());
                }
            }
            if (!configFile.exists()) {
                YamlConfiguration minimal = new YamlConfiguration();
                minimal.set("chat-prefix", (Object)DEFAULT_PREFIX);
                try {
                    minimal.save(configFile);
                    VoiceServer.plugin.getLogger().info("Created new minimal config.yml with default prefix.");
                    created = true;
                }
                catch (IOException e) {
                    VoiceServer.plugin.getLogger().severe("Failed to create minimal config.yml: " + e.getMessage());
                }
            }
        }
        return created;
    }

    private static void validatePrefixAndFixIfNeeded(FileConfiguration cfg, File configFile) {
        String prefix = cfg.getString("chat-prefix");
        if (prefix == null || prefix.trim().isEmpty()) {
            cfg.set("chat-prefix", (Object)DEFAULT_PREFIX);
            DataUtils.saveConfigFile(configFile);
            VoiceServer.plugin.getLogger().warning("chat-prefix was missing or empty \u2013 set to default value.");
        }
    }

    private static void internalLoad() {
        File dataFolder = VoiceServer.plugin.getDataFolder();
        File configFile = new File(dataFolder, CONFIG_NAME);
        isCracked = DataUtils.detectCrack();
        try {
            DataUtils.ensureDataFolder(dataFolder);
            boolean created = DataUtils.ensureConfigFile(configFile);
            config = YamlConfiguration.loadConfiguration((File)configFile);
            DataUtils.validatePrefixAndFixIfNeeded(config, configFile);
            loaded = true;
            String msg = "VoiceServer config.yml " + (created ? "created and " : "") + "loaded successfully.";
            VoiceServer.plugin.getLogger().info(msg);
        }
        catch (Exception e) {
            loaded = false;
            VoiceServer.plugin.getLogger().severe("Error while loading config.yml: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        loaded = false;
        isCracked = false;
    }
}

