/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.voiceServer.utils;

import de.jakomi1.voiceServer.VoiceServer;
import de.jakomi1.voiceServer.utils.MessageUtils;
import de.jakomi1.voiceServer.utils.TextUtils;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GroupUtils {
    public static final Map<UUID, String> groupPasswords = new HashMap<UUID, String>();
    public static final Map<UUID, Group> playerGroupMap = new HashMap<UUID, Group>();
    public static final List<String> PERSISTENCE_TYPES = List.of("persistent", "not-persistent");

    public static void joinPlayers(CommandSender sender, String[] args) {
        if (args.length < 3) {
            MessageUtils.sendError(sender, "Usage: /vcgroup join <player|@a|@s> \"<group name>\"");
            return;
        }
        List<Player> targets = TextUtils.parseTargets(sender, args[1]);
        String groupName = TextUtils.getQuotedArg(args, 2);
        if (groupName == null) {
            MessageUtils.sendError(sender, "Group name must be in quotes!");
            return;
        }
        Group newGroup = GroupUtils.findGroup(groupName);
        if (newGroup == null) {
            MessageUtils.sendError(sender, "Group not found.");
            return;
        }
        for (Player p : targets) {
            VoicechatConnection conn = VoiceServer.serverApi.getConnectionOf(p.getUniqueId());
            if (conn == null) {
                MessageUtils.sendError(sender, "Player not connected to voice chat: " + p.getName());
                continue;
            }
            Group oldGroup = conn.getGroup();
            conn.setGroup(newGroup);
            if (oldGroup == null || oldGroup.getId().equals(newGroup.getId())) continue;
            long remaining = Bukkit.getOnlinePlayers().stream().map(pm -> VoiceServer.serverApi.getConnectionOf(pm.getUniqueId())).filter(Objects::nonNull).map(VoicechatConnection::getGroup).filter(arg_0 -> ((Group)oldGroup).equals(arg_0)).count();
            if (remaining != 0L || oldGroup.isPersistent()) continue;
            VoiceServer.serverApi.removeGroup(oldGroup.getId());
            groupPasswords.remove(oldGroup.getId());
        }
    }

    public static void kickPlayers(CommandSender sender, String[] args) {
        if (args.length < 2) {
            MessageUtils.sendError(sender, "Usage: /vcgroup kick <player|@a|@s|@r|@p>");
            return;
        }
        List<Player> targets = TextUtils.parseTargets(sender, args[1]);
        if (targets.isEmpty()) {
            MessageUtils.sendError(sender, "No valid players specified.");
            return;
        }
        for (Player p : targets) {
            VoicechatConnection conn = VoiceServer.serverApi.getConnectionOf(p.getUniqueId());
            if (conn == null || conn.getGroup() == null) continue;
            Group group = conn.getGroup();
            conn.setGroup(null);
            MessageUtils.sendSuccess(sender, "Kicked player: " + p.getName() + " from group: " + group.getName());
            long remaining = Bukkit.getOnlinePlayers().stream().map(pm -> VoiceServer.serverApi.getConnectionOf(pm.getUniqueId())).filter(Objects::nonNull).map(VoicechatConnection::getGroup).filter(arg_0 -> ((Group)group).equals(arg_0)).count();
            if (remaining != 0L || group.isPersistent()) continue;
            VoiceServer.serverApi.removeGroup(group.getId());
            groupPasswords.remove(group.getId());
            MessageUtils.sendSuccess(sender, "Old group removed (was empty): " + group.getName());
        }
    }

    public static void removeGroup(CommandSender sender, String[] args) {
        if (args.length < 2) {
            MessageUtils.sendError(sender, "Usage: /vcgroup remove \"<group name>\"");
            return;
        }
        String groupName = TextUtils.getQuotedArg(args, 1);
        if (groupName == null) {
            MessageUtils.sendError(sender, "Group name must be in quotes!");
            return;
        }
        Group group = GroupUtils.findGroup(groupName);
        if (group == null) {
            MessageUtils.sendError(sender, "Group not found.");
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            VoicechatConnection conn = VoiceServer.serverApi.getConnectionOf(p.getUniqueId());
            if (conn == null || conn.getGroup() == null || !conn.getGroup().getId().equals(group.getId())) continue;
            conn.setGroup(null);
        }
        VoiceServer.serverApi.removeGroup(group.getId());
        groupPasswords.remove(group.getId());
        MessageUtils.sendSuccess(sender, "Group removed: " + group.getName());
    }

    public static Group findGroup(String name) {
        return VoiceServer.serverApi.getGroups().stream().filter(g -> g.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static void listGroups(CommandSender sender) {
        List groups = VoiceServer.serverApi.getGroups().stream().toList();
        if (groups.isEmpty()) {
            MessageUtils.sendSuccess(sender, "No voice chat groups available.");
            return;
        }
        MessageUtils.sendSuccess(sender, "Voice chat groups:");
        for (Group g : groups) {
            boolean isLocked = groupPasswords.containsKey(g.getId());
            String displayName = TextUtils.quote(g.getName());
            String msg = ">> " + String.valueOf(ChatColor.AQUA) + g.getName() + (String)(isLocked ? String.valueOf(ChatColor.RED) + " [locked]" : "") + String.valueOf(ChatColor.GRAY) + " (" + TextUtils.typeToString(g.getType()) + ")";
            sender.sendMessage(TextUtils.getChatPrefix() + msg);
        }
    }

    public static void commandInfo(CommandSender sender, String[] args) {
        if (args.length < 2) {
            MessageUtils.sendError(sender, "Usage: /vcgroup info \"<group name>\"");
            return;
        }
        String groupName = TextUtils.getQuotedArg(args, 1);
        if (groupName == null) {
            MessageUtils.sendError(sender, "Group name must be in quotes!");
            return;
        }
        Group group = GroupUtils.findGroup(groupName);
        if (group == null) {
            MessageUtils.sendError(sender, "Group not found: " + groupName);
            return;
        }
        boolean hasPw = group.hasPassword() || groupPasswords.containsKey(group.getId());
        String typeStr = TextUtils.typeToString(group.getType());
        String persistence = group.isPersistent() ? "Yes" : "No";
        ArrayList<String> members = new ArrayList<String>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            VoicechatConnection conn = VoiceServer.serverApi.getConnectionOf(p.getUniqueId());
            if (conn == null || conn.getGroup() == null || !conn.getGroup().getId().equals(group.getId())) continue;
            members.add(p.getName());
        }
        MessageUtils.sendPlain(sender, "Group Info for " + group.getName());
        MessageUtils.sendPlain(sender, "Type: " + typeStr);
        MessageUtils.sendPlain(sender, "Persistent: " + persistence);
        MessageUtils.sendPlain(sender, "Locked: " + (hasPw ? "Yes" : "No"));
        MessageUtils.sendPlain(sender, "Members (" + members.size() + "): " + (members.isEmpty() ? "None" : String.join((CharSequence)", ", members)));
    }

    public static void createGroup(CommandSender sender, String[] args) {
        Group group;
        int argLen = args.length;
        if (argLen < 4) {
            MessageUtils.sendError(sender, "Usage: /vcgroup create <player|@a|@s> <type> \"<group name>\" [persistent] [\"password\"]");
            return;
        }
        List<Player> targets = TextUtils.parseTargets(sender, args[1]);
        if (targets.isEmpty()) {
            MessageUtils.sendError(sender, "No valid players specified.");
            return;
        }
        String typeArg = args[2].toLowerCase(Locale.ROOT);
        Group.Type type = TextUtils.typeFromString(typeArg);
        int nameIdx = 3;
        String groupName = TextUtils.getQuotedArg(args, nameIdx);
        if (groupName == null) {
            MessageUtils.sendError(sender, "Group name must be in quotes!");
            return;
        }
        int nextArgIdx = nameIdx + TextUtils.countQuotedArgs(args, nameIdx);
        boolean persistent = false;
        String password = null;
        if (argLen > nextArgIdx) {
            String arg4 = args[nextArgIdx];
            if (arg4.equalsIgnoreCase("persistent")) {
                persistent = true;
                if (argLen > nextArgIdx + 1) {
                    password = TextUtils.getQuotedArg(args, nextArgIdx + 1);
                }
            } else if (arg4.equalsIgnoreCase("not-persistent")) {
                persistent = false;
                if (argLen > nextArgIdx + 1) {
                    password = TextUtils.getQuotedArg(args, nextArgIdx + 1);
                }
            } else {
                password = TextUtils.getQuotedArg(args, nextArgIdx);
            }
        }
        if (GroupUtils.findGroup(groupName) != null) {
            MessageUtils.sendError(sender, "Group already exists: " + groupName);
            return;
        }
        if (password != null && !password.isEmpty()) {
            group = VoiceServer.serverApi.groupBuilder().setName(groupName).setPersistent(persistent).setPassword(password).setType(type).build();
            groupPasswords.put(group.getId(), password);
            MessageUtils.sendSuccess(sender, "Group created: " + groupName + " (locked, type=" + typeArg + ", persistent=" + persistent + ")");
        } else {
            group = VoiceServer.serverApi.groupBuilder().setName(groupName).setPersistent(persistent).setType(type).build();
            MessageUtils.sendSuccess(sender, "Group created: " + groupName + " (type=" + typeArg + ", persistent=" + persistent + ")");
        }
        for (Player p : targets) {
            VoicechatConnection conn = VoiceServer.serverApi.getConnectionOf(p.getUniqueId());
            if (conn == null) {
                MessageUtils.sendError(sender, "Player not connected to voice chat: " + p.getName());
                continue;
            }
            conn.setConnected(false);
            Group oldGroup = conn.getGroup();
            conn.setGroup(group);
            MessageUtils.sendSuccess(sender, "Moved player: " + p.getName() + " to group: " + group.getName());
            if (oldGroup == null || oldGroup.getId().equals(group.getId())) continue;
            long remaining = Bukkit.getOnlinePlayers().stream().map(pm -> VoiceServer.serverApi.getConnectionOf(pm.getUniqueId())).filter(Objects::nonNull).map(VoicechatConnection::getGroup).filter(arg_0 -> ((Group)oldGroup).equals(arg_0)).count();
            if (remaining != 0L || oldGroup.isPersistent()) continue;
            VoiceServer.serverApi.removeGroup(oldGroup.getId());
            groupPasswords.remove(oldGroup.getId());
            MessageUtils.sendSuccess(sender, "Old group removed (was empty): " + oldGroup.getName());
        }
    }
}

