/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.voiceServer;

import de.jakomi1.voiceServer.commands.EmptyTabCompleter;
import de.jakomi1.voiceServer.commands.VoiceGroupCommand;
import de.jakomi1.voiceServer.commands.VoiceServerCommand;
import de.jakomi1.voiceServer.listener.CreateGroupListener;
import de.jakomi1.voiceServer.listener.JoinGroupListener;
import de.jakomi1.voiceServer.listener.LeaveGroupListener;
import de.jakomi1.voiceServer.utils.DataUtils;
import de.maxhenkel.voicechat.api.BukkitVoicechatService;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.CreateGroupEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.JoinGroupEvent;
import de.maxhenkel.voicechat.api.events.LeaveGroupEvent;
import java.util.Objects;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VoiceServer
extends JavaPlugin
implements VoicechatPlugin,
CommandExecutor,
TabCompleter {
    public static VoicechatServerApi serverApi;
    public static JavaPlugin plugin;

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(CreateGroupEvent.class, CreateGroupListener::onGroupCreatedEvent);
        registration.registerEvent(JoinGroupEvent.class, JoinGroupListener::onGroupJoinEvent);
        registration.registerEvent(LeaveGroupEvent.class, LeaveGroupListener::onGroupLeaveEvent);
    }

    public void onEnable() {
        plugin = this;
        BukkitVoicechatService service = (BukkitVoicechatService)this.getServer().getServicesManager().load(BukkitVoicechatService.class);
        if (service == null) {
            this.getLogger().warning("[VoiceServer] Voice chat service not found. Plugin disabled.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        service.registerPlugin((VoicechatPlugin)this);
        DataUtils.loadConfig();
        String prefixString = DataUtils.getChatPrefix();
        if (DataUtils.isCracked()) {
            plugin.getLogger().info("VoiceServer Plugin enabled with Cracked Attack.");
        } else {
            plugin.getLogger().info("VoiceServer Plugin enabled.");
        }
        this.registerCommands();
    }

    private void registerCommands() {
        this.registerCommand("vcserver", new VoiceServerCommand(), new VoiceServerCommand());
        this.registerCommand("vcgroup", new VoiceGroupCommand(), new VoiceGroupCommand());
    }

    private void registerCommand(String command, CommandExecutor executor, TabCompleter completer) {
        PluginCommand cmd = this.getServer().getPluginCommand(command);
        if (cmd != null) {
            cmd.setExecutor(executor);
            cmd.setTabCompleter(Objects.requireNonNullElseGet(completer, EmptyTabCompleter::new));
        } else {
            this.getLogger().warning("Cannot register the \"/" + command + "\" command");
        }
    }

    public String getPluginId() {
        return "voiceserver";
    }

    public void initialize(VoicechatApi api) {
        if (!(api instanceof VoicechatServerApi)) {
            throw new IllegalStateException("Expected VoicechatServerApi");
        }
        VoicechatServerApi s = (VoicechatServerApi)api;
        serverApi = s;
    }
}

