/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.voiceServer.commands;

import de.jakomi1.voiceServer.VoiceServer;
import de.jakomi1.voiceServer.utils.GroupUtils;
import de.jakomi1.voiceServer.utils.MessageUtils;
import de.jakomi1.voiceServer.utils.TextUtils;
import de.maxhenkel.voicechat.api.Group;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class VoiceGroupCommand
implements CommandExecutor,
TabCompleter {
    public static final List<String> SUBCOMMANDS = List.of("list", "create", "join", "kick", "remove", "info");
    public static final List<String> GROUP_TYPES = List.of("normal", "open", "isolated");

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length == 0) {
            MessageUtils.showVoiceGroupCommandUsage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "list": {
                GroupUtils.listGroups(sender);
                break;
            }
            case "create": {
                GroupUtils.createGroup(sender, args);
                break;
            }
            case "join": {
                GroupUtils.joinPlayers(sender, args);
                break;
            }
            case "kick": {
                GroupUtils.kickPlayers(sender, args);
                break;
            }
            case "remove": {
                GroupUtils.removeGroup(sender, args);
                break;
            }
            case "info": {
                GroupUtils.commandInfo(sender, args);
                break;
            }
            default: {
                MessageUtils.showVoiceGroupCommandUsage(sender);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        List<String> merged = TextUtils.mergeQuoted(args);
        ArrayList<String> suggestions = new ArrayList<String>();
        if (merged.isEmpty()) {
            return suggestions;
        }
        String sub = merged.get(0).toLowerCase();
        List<String> quotedGroups = VoiceServer.serverApi.getGroups().stream().map(Group::getName).map(TextUtils::quote).toList();
        switch (merged.size()) {
            case 1: {
                SUBCOMMANDS.stream().filter(sc -> sc.startsWith(sub)).forEach(suggestions::add);
                break;
            }
            case 2: {
                if (List.of("create", "join", "kick").contains(sub)) {
                    suggestions.addAll(List.of("@a", "@s", "@r", "@p"));
                    Bukkit.getOnlinePlayers().forEach(p -> suggestions.add(p.getName()));
                    suggestions.removeIf(n -> !n.toLowerCase().startsWith(((String)merged.get(1)).toLowerCase()));
                    break;
                }
                if (!sub.equals("remove") && !sub.equals("info")) break;
                suggestions.addAll(quotedGroups);
                break;
            }
            case 3: {
                if (sub.equals("create")) {
                    for (String type : GROUP_TYPES) {
                        if (!type.startsWith(merged.get(2).toLowerCase())) continue;
                        suggestions.add(type);
                    }
                    break;
                }
                if (!sub.equals("join")) break;
                suggestions.addAll(quotedGroups);
                break;
            }
            case 4: {
                if (!sub.equals("create")) break;
                suggestions.add("\"<group name>\"");
                break;
            }
            case 5: {
                String groupNameArg;
                if (!sub.equals("create") || !(groupNameArg = merged.get(3)).startsWith("\"") || !groupNameArg.endsWith("\"")) break;
                for (String ptype : GroupUtils.PERSISTENCE_TYPES) {
                    if (!ptype.startsWith(merged.get(4).toLowerCase())) continue;
                    suggestions.add(ptype);
                }
                break;
            }
            case 6: {
                String persistArg;
                if (!sub.equals("create") || !(persistArg = merged.get(4).toLowerCase()).equals("persistent") && !persistArg.equals("not-persistent")) break;
                suggestions.add("\"<password>\"");
                break;
            }
        }
        return suggestions;
    }
}

