/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.voiceServer.commands;

import de.jakomi1.voiceServer.utils.DataUtils;
import de.jakomi1.voiceServer.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class VoiceServerCommand
implements CommandExecutor,
TabCompleter {
    public static final List<String> SUBCOMMANDS = List.of("reload");

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length != 1) {
            MessageUtils.showVoiceServerCommandUsage(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            DataUtils.reloadConfig();
            MessageUtils.sendSuccess(sender, "VoiceServer config was successfully reloaded");
        } else {
            MessageUtils.showVoiceServerCommandUsage(sender);
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length != 1) {
            return suggestions;
        }
        if (args.length == 1) {
            SUBCOMMANDS.stream().filter(sub -> sub.startsWith(args[0].toLowerCase())).forEach(suggestions::add);
        }
        return suggestions;
    }
}

