/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.voiceServer.utils;

import de.jakomi1.voiceServer.utils.DataUtils;
import de.maxhenkel.voicechat.api.Group;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TextUtils {
    public static List<String> mergeQuoted(String[] args) {
        ArrayList<String> merged = new ArrayList<String>();
        StringBuilder current = null;
        for (String arg : args) {
            if (current == null) {
                if (arg.startsWith("\"") && !arg.endsWith("\"")) {
                    current = new StringBuilder(arg);
                    continue;
                }
                merged.add(arg);
                continue;
            }
            current.append(" ").append(arg);
            if (!arg.endsWith("\"")) continue;
            merged.add(current.toString());
            current = null;
        }
        if (current != null) {
            merged.add(current.toString());
        }
        return merged;
    }

    public static String quote(String groupName) {
        return "\"" + groupName + "\"";
    }

    public static Group.Type typeFromString(@Nullable String type) {
        if (type == null) {
            return Group.Type.NORMAL;
        }
        return switch (type.trim().toLowerCase(Locale.ROOT)) {
            case "open" -> Group.Type.OPEN;
            case "isolated" -> Group.Type.ISOLATED;
            default -> Group.Type.NORMAL;
        };
    }

    public static String typeToString(Group.Type type) {
        if (type == Group.Type.OPEN) {
            return "open";
        }
        if (type == Group.Type.ISOLATED) {
            return "isolated";
        }
        return "normal";
    }

    public static List<Player> parseTargets(CommandSender sender, String token) {
        ArrayList<Player> online = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        return switch (token) {
            case "@a" -> online;
            case "@s" -> {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    yield List.of(p);
                }
                yield List.of();
            }
            case "@r" -> {
                if (online.isEmpty()) {
                    yield List.of();
                }
                yield List.of((Player)online.get(new Random().nextInt(online.size())));
            }
            case "@p" -> {
                if (!(sender instanceof Player)) {
                    yield List.of();
                }
                Player ps = (Player)sender;
                Player closest = null;
                double minDist = Double.MAX_VALUE;
                for (Player pl : online) {
                    double dist;
                    if (pl.equals((Object)ps) || !((dist = ps.getLocation().distance(pl.getLocation())) < minDist)) continue;
                    minDist = dist;
                    closest = pl;
                }
                if (closest != null) {
                    yield List.of(closest);
                }
                yield List.of();
            }
            default -> {
                Player p = Bukkit.getPlayerExact((String)token);
                if (p == null) {
                    yield List.of();
                }
                yield List.of(p);
            }
        };
    }

    public static String getQuotedArg(String[] args, int startIdx) {
        if (startIdx >= args.length) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        boolean ended = false;
        for (int i = startIdx; i < args.length; ++i) {
            String arg = args[i];
            if (!started && arg.startsWith("\"")) {
                sb.append(arg.substring(1));
                started = true;
                if (!arg.endsWith("\"") || arg.length() <= 1) continue;
                sb.setLength(sb.length() - 1);
                ended = true;
                break;
            }
            if (!started) continue;
            sb.append(" ");
            if (arg.endsWith("\"")) {
                sb.append(arg, 0, arg.length() - 1);
                ended = true;
                break;
            }
            sb.append(arg);
        }
        return started && ended ? sb.toString() : null;
    }

    public static int countQuotedArgs(String[] args, int startIdx) {
        if (startIdx >= args.length) {
            return 0;
        }
        int count = 0;
        boolean started = false;
        boolean ended = false;
        for (int i = startIdx; i < args.length; ++i) {
            String arg = args[i];
            ++count;
            if (!started && arg.startsWith("\"")) {
                started = true;
                if (!arg.endsWith("\"") || arg.length() <= 1) continue;
                ended = true;
                break;
            }
            if (!started || !arg.endsWith("\"")) continue;
            ended = true;
            break;
        }
        return started && ended ? count : 1;
    }

    public static Component getChatPrefix() {
        return Component.text((String)DataUtils.getChatPrefix());
    }
}

