/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.util.Mth;
import net.minecraft.util.OptionEnum;
import org.jetbrains.annotations.NotNull;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.effect.GradientEffect;
import snownee.textanimator.effect.RainbowEffect;

public enum TextAnimationMode implements OptionEnum
{
    ALL("all"),
    NONE("none"),
    NO_RAINBOW("no_rainbow");

    private static final TextAnimationMode[] BY_ID;
    private final String key;

    private TextAnimationMode(String key) {
        this.key = "options.textanimator.animation." + key;
    }

    public static TextAnimationMode byId(int i) {
        return BY_ID[Mth.positiveModulo((int)i, (int)BY_ID.length)];
    }

    public int getId() {
        return this.ordinal();
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public boolean shouldApply(Effect effect) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> false;
            case 2 -> effect.getClass() != RainbowEffect.class && effect.getClass() != GradientEffect.class;
        };
    }

    static {
        BY_ID = (TextAnimationMode[])Arrays.stream(TextAnimationMode.values()).sorted(Comparator.comparingInt(TextAnimationMode::getId)).toArray(TextAnimationMode[]::new);
    }
}

