/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.mixin;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.network.chat.Style;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.textanimator.duck.TAStyle;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.typewriter.TypewriterTrack;

@Mixin(value={Style.class})
public class StyleMixin
implements TAStyle {
    @Unique
    private ImmutableList<Effect> textanimator$effects = ImmutableList.of();
    @Unique
    private TypewriterTrack textanimator$track;
    @Unique
    private int textanimator$typewriterIndex = -1;

    @Override
    public ImmutableList<Effect> textanimator$getEffects() {
        return this.textanimator$effects;
    }

    @Override
    public void textanimator$setEffects(ImmutableList<Effect> effects) {
        this.textanimator$effects = effects;
    }

    @Override
    public void textanimator$addEffect(Effect effect) {
        this.textanimator$effects = this.textanimator$effects.isEmpty() ? ImmutableList.of((Object)effect) : ImmutableList.builder().addAll(this.textanimator$effects).add((Object)effect).build();
    }

    @Override
    public TypewriterTrack textanimator$getTypewriterTrack() {
        return this.textanimator$track;
    }

    @Override
    public void textanimator$setTypewriterTrack(TypewriterTrack track) {
        this.textanimator$track = track;
    }

    @Override
    public int textanimator$getTypewriterIndex() {
        return this.textanimator$typewriterIndex;
    }

    @Override
    public void textanimator$setTypewriterIndex(int index) {
        this.textanimator$typewriterIndex = index;
    }

    @ModifyReturnValue(method={"withColor(Lnet/minecraft/network/chat/TextColor;)Lnet/minecraft/network/chat/Style;", "withBold", "withItalic", "withUnderlined", "withStrikethrough", "withObfuscated", "withClickEvent", "withHoverEvent", "withInsertion", "withFont", "applyFormat", "applyLegacyFormat", "applyFormats"}, at={@At(value="RETURN")})
    private Style textanimator$applyTo(Style original) {
        Style self = (Style)this;
        if (self == original) {
            return original;
        }
        if (this.textanimator$getEffects().isEmpty() && this.textanimator$getTypewriterTrack() == null) {
            return original;
        }
        ((TAStyle)original).textanimator$setEffects(this.textanimator$getEffects());
        if (this.textanimator$getTypewriterTrack() != null) {
            ((TAStyle)original).textanimator$setTypewriterTrack(this.textanimator$getTypewriterTrack());
            ((TAStyle)original).textanimator$setTypewriterIndex(this.textanimator$getTypewriterIndex());
        }
        return original;
    }

    @ModifyReturnValue(method={"applyTo"}, at={@At(value="RETURN")})
    private Style textanimator$applyTo(Style original, Style that) {
        Style self = (Style)this;
        if (self == original || that == original) {
            return original;
        }
        ImmutableList<Effect> effects = this.textanimator$getEffects();
        TypewriterTrack track = this.textanimator$getTypewriterTrack();
        int index = this.textanimator$getTypewriterIndex();
        TAStyle thatStyle = (TAStyle)that;
        ImmutableList<Effect> thatEffects = thatStyle.textanimator$getEffects();
        TypewriterTrack thatTrack = thatStyle.textanimator$getTypewriterTrack();
        int thatIndex = thatStyle.textanimator$getTypewriterIndex();
        TAStyle originalStyle = (TAStyle)original;
        originalStyle.textanimator$setEffects(effects.isEmpty() ? thatEffects : effects);
        originalStyle.textanimator$setTypewriterTrack(track == null ? thatTrack : track);
        originalStyle.textanimator$setTypewriterIndex(index == -1 ? thatIndex : index);
        return original;
    }

    @Inject(method={"equals"}, at={@At(value="HEAD")}, cancellable=true)
    private void textanimator$equals(Object obj, CallbackInfoReturnable<Boolean> cir) {
        if (this != obj && obj instanceof TAStyle) {
            TAStyle style = (TAStyle)obj;
            if (!Objects.equals(this.textanimator$getEffects(), style.textanimator$getEffects())) {
                cir.setReturnValue((Object)false);
            }
            if (!Objects.equals(this.textanimator$getTypewriterTrack(), style.textanimator$getTypewriterTrack())) {
                cir.setReturnValue((Object)false);
            }
            if (this.textanimator$getTypewriterIndex() != style.textanimator$getTypewriterIndex()) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Mixin(value={Style.Serializer.class})
    public static class SerializerMixin {
        @Mutable
        @Shadow
        @Final
        public static MapCodec<Style> MAP_CODEC;
        @Mutable
        @Shadow
        @Final
        public static Codec<Style> CODEC;

        @Inject(method={"<clinit>"}, at={@At(value="RETURN")})
        private static void textanimator$attachCustomCodec(CallbackInfo ci) {
            MAP_CODEC = SerializerMixin.textanimator$wrapCodec(MAP_CODEC);
            CODEC = MAP_CODEC.codec();
        }

        @Unique
        private static MapCodec<Style> textanimator$wrapCodec(final MapCodec<Style> original) {
            return new MapCodec<Style>(){

                public <T> DataResult<Style> decode(DynamicOps<T> ops, MapLike<T> input) {
                    DataResult result = original.decode(ops, input);
                    if (result.isError()) {
                        return result;
                    }
                    DataResult effects = Effect.LIST_MAP_CODEC.decode(ops, input);
                    if (effects.isError()) {
                        return effects.map($ -> Style.EMPTY);
                    }
                    if (((List)effects.getOrThrow()).isEmpty()) {
                        return result;
                    }
                    return result.map(style -> {
                        ((TAStyle)style).textanimator$setEffects((ImmutableList<Effect>)ImmutableList.copyOf((Collection)((Collection)effects.getOrThrow())));
                        return style;
                    });
                }

                public <T> RecordBuilder<T> encode(Style style, DynamicOps<T> ops, RecordBuilder<T> builder) {
                    original.encode((Object)style, ops, builder);
                    ImmutableList<Effect> effects = ((TAStyle)style).textanimator$getEffects();
                    if (effects.isEmpty()) {
                        return builder;
                    }
                    Effect.LIST_MAP_CODEC.encode(effects, ops, builder);
                    return builder;
                }

                public <T> Stream<T> keys(DynamicOps<T> ops) {
                    return Stream.concat(original.keys(ops), Stream.of(ops.createString("ta$effects")));
                }

                public String toString() {
                    return original.toString() + " (TextAnimator modified)";
                }
            };
        }
    }
}

