/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.StringDecomposer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.textanimator.duck.TAStyle;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.typewriter.TypewriterEffect;
import snownee.textanimator.typewriter.TypewriterTracks;
import snownee.textanimator.util.CommonProxy;

@Mixin(value={TranslatableContents.class})
public abstract class TranslatableContentsMixin {
    @Inject(method={"decomposeTemplate"}, at={@At(value="HEAD")})
    private void textanimator$decomposeTemplate(CallbackInfo ci, @Local(argsOnly=true) LocalRef<String> stringRef, @Share(value="style") LocalRef<Style> newStyle) {
        String string = (String)stringRef.get();
        Pair<TypewriterEffect, Integer> pair = TypewriterEffect.find(string);
        if (pair == null) {
            newStyle.set((Object)CommonProxy.clone(Style.EMPTY));
            return;
        }
        stringRef.set((Object)string.substring((Integer)pair.getSecond()));
        Style style = CommonProxy.clone(Style.EMPTY);
        TAStyle taStyle = (TAStyle)style;
        taStyle.textanimator$addEffect((Effect)pair.getFirst());
        taStyle.textanimator$setTypewriterTrack(TypewriterTracks.getInstance().get(new Object()));
        newStyle.set((Object)style);
    }

    @WrapOperation(method={"decomposeTemplate"}, at={@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V")})
    private void textanimator$flatmapChars(Consumer<FormattedText> instance, Object formattedText, Operation<Void> original, @Share(value="style") LocalRef<Style> newStyle) {
        Style style = (Style)newStyle.get();
        if (style == null) {
            original.call(new Object[]{instance, formattedText});
            return;
        }
        TAStyle taStyle = (TAStyle)style;
        boolean hasTypewriter = taStyle.textanimator$getTypewriterTrack() != null;
        MutableInt charsAccepted = new MutableInt(Math.max(0, taStyle.textanimator$getTypewriterIndex()));
        Style[] lastStyle = new Style[]{style};
        StringDecomposer.iterateFormatted((FormattedText)((FormattedText)formattedText), (Style)style, (i, style2, cp) -> {
            instance.accept(FormattedText.of((String)Character.toString(cp), (Style)style2));
            lastStyle[0] = style2;
            if (hasTypewriter) {
                charsAccepted.increment();
            }
            return true;
        });
        Style continued = CommonProxy.clone(lastStyle[0]);
        if (hasTypewriter) {
            ((TAStyle)continued).textanimator$setTypewriterIndex(charsAccepted.intValue());
        }
        newStyle.set((Object)continued);
    }
}

