/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.mixin.client;

import com.google.common.collect.Lists;
import java.util.Objects;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_384;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5251;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.textanimator.TextAnimationMode;
import snownee.textanimator.TextAnimatorClient;
import snownee.textanimator.duck.TABakedGlyph;
import snownee.textanimator.duck.TAStyle;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.effect.EffectSettings;
import snownee.textanimator.effect.NeonEffect;
import snownee.textanimator.mixin.client.FontAccess;
import snownee.textanimator.typewriter.TypewriterTrack;

@Mixin(value={class_327.class_5232.class}, priority=1200)
public abstract class StringRenderOutputMixin {
    @Shadow
    @Final
    private Matrix4f field_24247;
    @Final
    @Shadow
    class_4597 field_24239;
    @Shadow
    float field_24250;
    @Shadow
    float field_24251;
    @Final
    @Shadow(remap=false, aliases={"f_92938_", "field_24240", "b"})
    class_327 this$0;
    @Final
    @Shadow
    private boolean field_24241;
    @Final
    @Shadow
    private float field_24242;
    @Final
    @Shadow
    private float field_24246;
    @Final
    @Shadow
    private float field_24245;
    @Final
    @Shadow
    private float field_24243;
    @Final
    @Shadow
    private float field_24244;
    @Final
    @Shadow
    private class_327.class_6415 field_33997;
    @Final
    @Shadow
    private int field_24249;

    @Inject(method={"accept"}, at={@At(value="HEAD")}, cancellable=true)
    private void textanimator$accept(int index, class_2583 style, int codepoint, CallbackInfoReturnable<Boolean> cir) {
        float b;
        float g;
        float r;
        TAStyle taStyle = (TAStyle)style;
        if (taStyle.textanimator$getEffects().isEmpty()) {
            return;
        }
        class_377 fontSet = ((FontAccess)this.this$0).callGetFontSet(style.method_27708());
        class_379 glyphInfo = fontSet.method_2011(codepoint, ((FontAccess)this.this$0).getFilterFishyGlyphs());
        class_382 bakedGlyph = style.method_10987() && codepoint != 32 ? fontSet.method_2013(glyphInfo) : fontSet.method_2014(codepoint);
        float a = this.field_24246;
        class_5251 textColor = style.method_10973();
        if (textColor != null) {
            int k = textColor.method_27716();
            r = (float)(k >> 16 & 0xFF) / 255.0f * this.field_24242;
            g = (float)(k >> 8 & 0xFF) / 255.0f * this.field_24242;
            b = (float)(k & 0xFF) / 255.0f * this.field_24242;
        } else {
            r = this.field_24243;
            g = this.field_24244;
            b = this.field_24245;
        }
        float shadowOffset = this.field_24241 ? glyphInfo.method_16800() : 0.0f;
        TypewriterTrack typewriterTrack = taStyle.textanimator$getTypewriterTrack();
        int typingIndex = taStyle.textanimator$getTypewriterIndex();
        EffectSettings settings = new EffectSettings(codepoint, index + Math.max(typingIndex, 0), this.field_24241, typewriterTrack, typingIndex);
        settings.x = this.field_24250 + shadowOffset;
        settings.y = this.field_24251 + shadowOffset;
        settings.r = r;
        settings.g = g;
        settings.b = b;
        settings.a = a;
        settings.shadowOffset = shadowOffset;
        settings.siblings = Lists.newArrayList((Object[])new EffectSettings[]{settings});
        TextAnimationMode animationMode = TextAnimatorClient.getTextAnimationMode();
        for (int i = taStyle.textanimator$getEffects().size() - 1; i >= 0; --i) {
            Effect effect = (Effect)taStyle.textanimator$getEffects().get(i);
            if (!animationMode.shouldApply(effect)) continue;
            int size = settings.siblings.size();
            for (int j = 0; j < size; ++j) {
                effect.apply(settings.siblings.get(j));
            }
        }
        if (!(bakedGlyph instanceof class_384)) {
            for (EffectSettings sibling : settings.siblings) {
                this.textanimator$renderChar(sibling, codepoint, style, fontSet, glyphInfo, bakedGlyph);
            }
        }
        r = settings.r;
        g = settings.g;
        b = settings.b;
        a = settings.a;
        float glyphWidth = glyphInfo.method_16798(style.method_10984());
        if (a != 0.0f && style.method_10986()) {
            this.method_27532(new class_382.class_328(this.field_24250 + shadowOffset - 1.0f, this.field_24251 + shadowOffset + 4.5f, this.field_24250 + shadowOffset + glyphWidth, this.field_24251 + shadowOffset + 4.5f - 1.0f, 0.01f, r, g, b, a));
        }
        if (a != 0.0f && style.method_10965()) {
            this.method_27532(new class_382.class_328(this.field_24250 + shadowOffset - 1.0f, this.field_24251 + shadowOffset + 9.0f, this.field_24250 + shadowOffset + glyphWidth, this.field_24251 + shadowOffset + 9.0f - 1.0f, 0.01f, r, g, b, a));
        }
        this.field_24250 += glyphWidth;
        cir.setReturnValue((Object)true);
    }

    @Unique
    private void textanimator$renderChar(EffectSettings settings, int oCodepoint, class_2583 style, class_377 fontSet, class_379 glyphInfo, class_382 bakedGlyph) {
        if (settings.a == 0.0f) {
            return;
        }
        if (settings.codepoint != oCodepoint && (bakedGlyph = fontSet.method_2014(settings.codepoint)) instanceof class_384) {
            return;
        }
        class_4588 vertexConsumer = this.field_24239.getBuffer(bakedGlyph.method_24045(this.field_33997));
        Matrix4f pose = this.field_24247;
        if (settings.rot != 0.0f) {
            glyphWidth = glyphInfo.method_16798(style.method_10984());
            float f = settings.rot;
            float f2 = glyphWidth / 2.0f;
            Objects.requireNonNull(this.this$0);
            pose = TextAnimatorClient.rotate(pose, settings, f, f2, 9.0f / 2.0f);
        } else if (settings.pendRad != 0.0f) {
            glyphWidth = glyphInfo.method_16798(style.method_10984());
            pose = TextAnimatorClient.rotate(pose, settings, settings.pendRad, glyphWidth / 2.0f, 0.0f);
        }
        TABakedGlyph glyph = (TABakedGlyph)bakedGlyph;
        glyph.textanimator$render(settings, style.method_10966(), 0.0f, pose, vertexConsumer, this.field_24249);
        if (style.method_10984()) {
            glyph.textanimator$render(settings, style.method_10966(), glyphInfo.method_16799(), pose, vertexConsumer, this.field_24249);
        }
        float boldOffset = style.method_10984() ? glyphInfo.method_16799() : 0.0f;
        TAStyle taStyle = (TAStyle)style;
        TextAnimationMode animationMode = TextAnimatorClient.getTextAnimationMode();
        for (Effect effect : taStyle.textanimator$getEffects()) {
            if (!(effect instanceof NeonEffect)) continue;
            NeonEffect neonEffect = (NeonEffect)effect;
            if (!animationMode.shouldApply(effect)) continue;
            TextAnimatorClient.renderNeonEffect(neonEffect, bakedGlyph, style.method_10984(), style.method_10966(), boldOffset, settings, pose, vertexConsumer, settings.r, settings.g, settings.b, settings.a, this.field_24249);
        }
    }

    @Shadow
    protected abstract void method_27532(class_382.class_328 var1);
}

