/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.effect;

import java.util.Random;
import net.minecraft.class_156;
import snownee.textanimator.effect.BaseEffect;
import snownee.textanimator.effect.EffectSettings;
import snownee.textanimator.effect.params.Params;

public class GlitchEffect
extends BaseEffect {
    private final float frequency;
    private final float jitterChance;
    private final float blinkChance;
    private final float shiftChance;

    public GlitchEffect(Params params) {
        super(params);
        this.frequency = (float)params.getDouble("f").orElse(1.0);
        this.jitterChance = (float)params.getDouble("j").orElse(0.015);
        this.blinkChance = (float)params.getDouble("b").orElse(0.003);
        this.shiftChance = (float)params.getDouble("s").orElse(0.08);
    }

    @Override
    public void apply(EffectSettings settings) {
        Random random2;
        double time = (double)class_156.method_658() * 0.025 * (double)this.frequency;
        int pulse = (int)time % 3;
        Random random = new Random((long)(settings.index + settings.codepoint) + (long)(time * 1000.0));
        random.nextFloat();
        if (pulse == 1 && random.nextFloat() < this.jitterChance) {
            settings.x += (random.nextFloat() - 0.5f) * 8.0f;
            settings.y += (random.nextFloat() - 0.5f) * 4.0f;
        }
        if (random.nextFloat() < this.blinkChance) {
            settings.a = settings.a * ((double)random.nextFloat() < 0.3 ? 0.0f : 0.3f);
        }
        if ((random2 = new Random((long)(time *= 2.0) * 1000L * (long)this.hashCode())).nextFloat() < this.shiftChance) {
            if (settings.isShadow) {
                settings.siblings.add(settings.copy());
                settings.x -= settings.shadowOffset;
                settings.y -= settings.shadowOffset;
            }
            float mask = 0.5f + (random2.nextFloat() - 0.5f) * 0.5f;
            float offset = 0.75f + random2.nextFloat() * 0.75f;
            if (random2.nextBoolean()) {
                offset = -offset;
            }
            EffectSettings copy = settings.copy();
            copy.x += offset;
            copy.a *= Math.min(1.0f, 0.5f + random2.nextFloat());
            if (copy.isShadow) {
                copy.y -= 1.0f;
                copy.r = copy.r > 0.5f ? copy.r - 0.5f : copy.r + 0.5f;
                copy.g *= 0.2f;
                copy.b *= 0.2f;
            }
            copy.maskBottom = mask;
            settings.siblings.add(copy);
            settings.maskTop = 1.0f - mask;
            settings.x -= offset;
            settings.a *= Math.min(1.0f, 0.5f + random2.nextFloat());
            if (settings.isShadow) {
                settings.y += 1.0f;
                settings.r *= 0.2f;
                settings.g = settings.g > 0.5f ? settings.g - 0.5f : settings.g + 0.5f;
                settings.b = settings.b > 0.5f ? settings.b - 0.5f : settings.b + 0.5f;
            }
        }
    }

    @Override
    public String getName() {
        return "glitch";
    }
}

