/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.effect;

import net.minecraft.class_156;
import snownee.textanimator.effect.BaseEffect;
import snownee.textanimator.effect.EffectSettings;
import snownee.textanimator.effect.params.Params;

public class GradientEffect
extends BaseEffect {
    private static final float[] defaultFrom = GradientEffect.parseColor("5BCEFA").orElseThrow();
    private static final float[] defaultTo = GradientEffect.parseColor("F5A9B8").orElseThrow();
    private final float[] fromRGB;
    private final float[] toRGB;
    private final boolean useHSV;
    private final float speed;
    private final float span;
    private final boolean cyclic;

    public GradientEffect(Params params) {
        super(params);
        this.fromRGB = GradientEffect.parseColor(params, "from", defaultFrom);
        this.toRGB = GradientEffect.parseColor(params, "to", defaultTo);
        this.useHSV = params.getBoolOr("hue", false);
        this.speed = (float)params.getDouble("f").orElse(0.0);
        this.span = (float)params.getDouble("sp").orElse(20.0);
        this.cyclic = !params.getBoolOr("uni", false);
    }

    @Override
    public void apply(EffectSettings settings) {
        float[] rgb;
        if (settings.isShadow) {
            return;
        }
        float tIndex = this.span > 0.0f ? (float)settings.index % this.span / this.span : 0.0f;
        float tTime = this.speed > 0.0f ? (float)((double)class_156.method_658() * 0.001 * (double)this.speed % 1.0) : 0.0f;
        float t = (tIndex + tTime) % 1.0f;
        if (this.cyclic && (t = t * 2.0f % 2.0f) > 1.0f) {
            t = 2.0f - t;
        }
        if (this.useHSV) {
            float[] hsv1 = GradientEffect.rgbToHsv(this.fromRGB);
            float[] hsv2 = GradientEffect.rgbToHsv(this.toRGB);
            float h = GradientEffect.lerpHue(hsv1[0], hsv2[0], t);
            float s = GradientEffect.lerp(hsv1[1], hsv2[1], t);
            float v = GradientEffect.lerp(hsv1[2], hsv2[2], t);
            rgb = GradientEffect.hsvToRgb(h, s, v);
        } else {
            rgb = new float[]{GradientEffect.lerp(this.fromRGB[0], this.toRGB[0], t), GradientEffect.lerp(this.fromRGB[1], this.toRGB[1], t), GradientEffect.lerp(this.fromRGB[2], this.toRGB[2], t)};
        }
        settings.r = rgb[0];
        settings.g = rgb[1];
        settings.b = rgb[2];
    }

    @Override
    public String getName() {
        return "grad";
    }

    private static float[] rgbToHsv(float[] rgb) {
        float s;
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float d = max - min;
        float f = s = max == 0.0f ? 0.0f : d / max;
        float h = d == 0.0f ? 0.0f : (max == r ? (g - b) / d + (float)(g < b ? 6 : 0) : (max == g ? (b - r) / d + 2.0f : (r - g) / d + 4.0f));
        return new float[]{h /= 6.0f, s, max};
    }

    private static float[] hsvToRgb(float h, float s, float v) {
        float[] fArray;
        int i = (int)(h * 6.0f);
        float f = h * 6.0f - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        switch (i % 6) {
            case 0: {
                float[] fArray2 = new float[3];
                fArray2[0] = v;
                fArray2[1] = t;
                fArray = fArray2;
                fArray2[2] = p;
                break;
            }
            case 1: {
                float[] fArray3 = new float[3];
                fArray3[0] = q;
                fArray3[1] = v;
                fArray = fArray3;
                fArray3[2] = p;
                break;
            }
            case 2: {
                float[] fArray4 = new float[3];
                fArray4[0] = p;
                fArray4[1] = v;
                fArray = fArray4;
                fArray4[2] = t;
                break;
            }
            case 3: {
                float[] fArray5 = new float[3];
                fArray5[0] = p;
                fArray5[1] = q;
                fArray = fArray5;
                fArray5[2] = v;
                break;
            }
            case 4: {
                float[] fArray6 = new float[3];
                fArray6[0] = t;
                fArray6[1] = p;
                fArray = fArray6;
                fArray6[2] = v;
                break;
            }
            default: {
                float[] fArray7 = new float[3];
                fArray7[0] = v;
                fArray7[1] = p;
                fArray = fArray7;
                fArray7[2] = q;
            }
        }
        return fArray;
    }

    private static float lerpHue(float a, float b, float t) {
        float diff = (b - a + 1.0f) % 1.0f;
        if (diff > 0.5f) {
            diff -= 1.0f;
        }
        return (a + diff * t + 1.0f) % 1.0f;
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }
}

