/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_3532;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import snownee.textanimator.TextAnimator;
import snownee.textanimator.TextAnimatorClient;
import snownee.textanimator.TypewriterMode;
import snownee.textanimator.duck.TAStyle;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.effect.params.Params;
import snownee.textanimator.mixin.StringDecomposerAccess;
import snownee.textanimator.util.ClientProxy;

public class CommonProxy
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"TextAnimator");

    public static class_2583 clone(class_2583 style) {
        return style.method_10958(style.method_10970());
    }

    public static boolean iterateFormatted(String string, int i, class_2583 style, class_2583 plainStyle, class_5224 formattedCharSink) {
        StringBuilder sb;
        boolean byWord;
        int j = string.length();
        class_2583 curStyle = style;
        int typingIndex = -1;
        int lastBoundary = i;
        int charsEaten = i;
        IntList boundaries = IntList.of();
        TAStyle taStyle = (TAStyle)style;
        boolean bl = byWord = CommonProxy.isPhysicalClient() && TextAnimatorClient.getTypewriterMode() == TypewriterMode.BY_WORD;
        if (taStyle.textanimator$getTypewriterTrack() != null && (typingIndex = taStyle.textanimator$getTypewriterIndex()) == -1 && string.length() > 1) {
            Locale locale = CommonProxy.getLocale();
            BreakIterator breakIterator = byWord ? BreakIterator.getLineInstance(locale) : BreakIterator.getCharacterInstance(locale);
            sb = new StringBuilder();
            class_5223.method_27472((String)string, (int)i, (class_2583)class_2583.field_24360, (index, style1, codePoint) -> {
                sb.appendCodePoint(codePoint);
                return true;
            });
            breakIterator.setText(sb.toString());
            boundaries = new IntArrayList();
            int start = breakIterator.first();
            int end = breakIterator.next();
            while (end != -1) {
                boundaries.add(i + start);
                start = end;
                end = breakIterator.next();
            }
            typingIndex = i;
        }
        block3: for (int k = i; k < j; ++k) {
            char c = string.charAt(k);
            if (!boundaries.isEmpty() && charsEaten >= boundaries.getInt(0)) {
                int n = byWord ? class_3532.method_15340((int)(charsEaten - lastBoundary), (int)1, (int)5) : 1;
                lastBoundary = boundaries.removeInt(0);
                curStyle = CommonProxy.clone(curStyle);
                ((TAStyle)curStyle).textanimator$setTypewriterIndex(typingIndex += n);
            }
            if (c == '\u00a7') {
                if (k + 1 >= j) break;
                char d = string.charAt(k + 1);
                class_124 chatFormatting = class_124.method_544((char)d);
                if (chatFormatting != null) {
                    curStyle = chatFormatting == class_124.field_1070 ? plainStyle : curStyle.method_27707(chatFormatting);
                }
                ++k;
                continue;
            }
            if (c == '<') {
                sb = new StringBuilder();
                for (int l = k + 1; l < j; ++l) {
                    char ch = string.charAt(l);
                    if (ch == '>') {
                        String[] split = StringUtils.split((String)sb.toString(), (char)' ');
                        if (split.length == 0 || split[0].isEmpty()) break;
                        ImmutableList newEffects = null;
                        ImmutableList<Effect> effects = ((TAStyle)curStyle).textanimator$getEffects();
                        if (split[0].charAt(0) == '/') {
                            String tagName = split[0].substring(1);
                            if (!effects.isEmpty() && ((Effect)effects.get(effects.size() - 1)).getName().equals(tagName)) {
                                newEffects = effects.subList(0, effects.size() - 1);
                            }
                        } else {
                            try {
                                Effect effect = Effect.create(split, false);
                                newEffects = ImmutableList.builder().addAll(effects).add((Object)effect).build();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (newEffects == null) break;
                        curStyle = CommonProxy.clone(curStyle);
                        ((TAStyle)curStyle).textanimator$setEffects((ImmutableList<Effect>)newEffects);
                        k = l;
                        continue block3;
                    }
                    sb.append(ch);
                }
            }
            ++charsEaten;
            if (Character.isHighSurrogate(c)) {
                if (k + 1 >= j) {
                    if (formattedCharSink.accept(k, curStyle, 65533)) break;
                    return false;
                }
                char d = string.charAt(k + 1);
                if (Character.isLowSurrogate(d)) {
                    if (!formattedCharSink.accept(k, curStyle, Character.toCodePoint(c, d))) {
                        return false;
                    }
                    ++k;
                    ++charsEaten;
                    continue;
                }
                if (formattedCharSink.accept(k, curStyle, 65533)) continue;
                return false;
            }
            if (StringDecomposerAccess.callFeedChar(curStyle, formattedCharSink, k, c)) continue;
            return false;
        }
        return true;
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static void onEffectTypeRegistered(String type, Function<Params, Effect> factory) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientProxy.onEffectTypeRegistered(type, factory);
        }
    }

    public void onInitialize() {
        TextAnimator.init();
    }

    public static boolean isPhysicalClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }
}

