/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.util.Mth;
import net.minecraft.util.OptionEnum;
import org.jetbrains.annotations.NotNull;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.effect.GradientEffect;
import snownee.textanimator.effect.RainbowEffect;

public enum TextAnimationMode implements OptionEnum
{
    ALL("all"),
    NONE("none"),
    NO_RAINBOW("no_rainbow");

    private static final TextAnimationMode[] BY_ID;
    private final String key;

    private TextAnimationMode(String key) {
        this.key = "options.textanimator.animation." + key;
    }

    public static TextAnimationMode byId(int i) {
        return BY_ID[Mth.m_14100_((int)i, (int)BY_ID.length)];
    }

    public int m_35965_() {
        return this.ordinal();
    }

    @NotNull
    public String m_35968_() {
        return this.key;
    }

    public boolean shouldApply(Effect effect) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ALL -> true;
            case NONE -> false;
            case NO_RAINBOW -> effect.getClass() != RainbowEffect.class && effect.getClass() != GradientEffect.class;
        };
    }

    static {
        BY_ID = (TextAnimationMode[])Arrays.stream(TextAnimationMode.values()).sorted(Comparator.comparingInt(TextAnimationMode::m_35965_)).toArray(TextAnimationMode[]::new);
    }
}

