/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import snownee.textanimator.TextAnimationMode;
import snownee.textanimator.TypewriterMode;
import snownee.textanimator.duck.TAOptions;
import snownee.textanimator.effect.EffectSettings;
import snownee.textanimator.effect.NeonEffect;
import snownee.textanimator.mixin.client.FontAccess;

public class TextAnimatorClient {
    private static Vec2[] RANDOM_DIR;
    private static int defaultTypewriterInterval;

    public static void init() {
        int len = 30;
        ArrayList<Vec2> dirs = new ArrayList<Vec2>(len);
        float step = (float)(Math.PI * 2 / (double)len);
        for (int i = 0; i < len; ++i) {
            float rad = step * (float)i;
            dirs.add(new Vec2(Mth.m_14089_((float)rad), Mth.m_14031_((float)rad)));
        }
        Collections.shuffle(dirs);
        RANDOM_DIR = (Vec2[])dirs.toArray(Vec2[]::new);
    }

    public static TextAnimationMode getTextAnimationMode() {
        if (Minecraft.m_91087_() == null || Minecraft.m_91087_().f_91066_ == null) {
            return TextAnimationMode.ALL;
        }
        OptionInstance<TextAnimationMode> instance = ((TAOptions)Minecraft.m_91087_().f_91066_).textanimator$getTextAnimation();
        if (instance == null) {
            return TextAnimationMode.ALL;
        }
        return (TextAnimationMode)((Object)instance.m_231551_());
    }

    public static TypewriterMode getTypewriterMode() {
        if (Minecraft.m_91087_() == null || Minecraft.m_91087_().f_91066_ == null) {
            return TypewriterMode.BY_CHAR;
        }
        OptionInstance<TypewriterMode> instance = ((TAOptions)Minecraft.m_91087_().f_91066_).textanimator$getTypewriterMode();
        if (instance == null) {
            return TypewriterMode.BY_CHAR;
        }
        return (TypewriterMode)((Object)instance.m_231551_());
    }

    public static int defaultTypewriterInterval() {
        return defaultTypewriterInterval;
    }

    public static void setTypewriterSpeed(int speed) {
        speed = Mth.m_14045_((int)speed, (int)1, (int)9);
        int[] values = new int[]{4, 8, 12, 16, 20, 27, 36, 50, 70};
        defaultTypewriterInterval = values[9 - speed];
    }

    public static Vec2 getRandomDirection(int seed) {
        return RANDOM_DIR[Math.abs(seed) % RANDOM_DIR.length];
    }

    public static void renderNeonEffect(NeonEffect effect, BakedGlyph bakedGlyph, boolean bold, boolean italic, float boldOffset, EffectSettings settings, Matrix4f pose, VertexConsumer vertexConsumer, float baseR, float baseG, float baseB, float baseA, int packedLightCoords) {
        float alpha = baseA * effect.alphaMul;
        if (alpha <= 0.0f) {
            return;
        }
        for (int i = 0; i < effect.passes; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)effect.passes);
            float dx = (float)Math.cos(angle) * effect.radius;
            float dy = (float)Math.sin(angle) * effect.radius;
            float x = settings.x + dx;
            float y = settings.y + dy;
            ((FontAccess)Minecraft.m_91087_().f_91062_).callRenderChar(bakedGlyph, bold, italic, boldOffset, x, y, pose, vertexConsumer, baseR, baseG, baseB, alpha, packedLightCoords);
        }
    }

    public static Matrix4f rotate(Matrix4f pose, EffectSettings settings, float rad, float oX, float oY) {
        pose = new Matrix4f((Matrix4fc)pose);
        pose.translate(settings.x + oX, settings.y + oY, 0.0f);
        pose.rotate((Quaternionfc)Axis.f_252403_.m_252961_(rad));
        pose.translate(-oX, -oY, 0.0f);
        settings.x = 0.0f;
        settings.y = 0.0f;
        return pose;
    }
}

