/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import snownee.textanimator.TextAnimator;
import snownee.textanimator.TextAnimatorClient;
import snownee.textanimator.TypewriterMode;
import snownee.textanimator.duck.TAStyle;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.effect.params.Params;
import snownee.textanimator.mixin.StringDecomposerAccess;
import snownee.textanimator.util.ClientProxy;

@Mod(value="textanimator")
public class CommonProxy {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"TextAnimator");

    public CommonProxy() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        TextAnimator.init();
        if (CommonProxy.isPhysicalClient()) {
            TextAnimatorClient.init();
            ClientProxy.init();
        }
    }

    public static Style clone(Style style) {
        return style.m_131142_(style.m_131182_());
    }

    public static boolean iterateFormatted(String string, int i, Style style, Style plainStyle, FormattedCharSink formattedCharSink) {
        StringBuilder sb;
        boolean byWord;
        int j = string.length();
        Style curStyle = style;
        int typingIndex = -1;
        int lastBoundary = i;
        int charsEaten = i;
        IntList boundaries = IntList.of();
        TAStyle taStyle = (TAStyle)style;
        boolean bl = byWord = CommonProxy.isPhysicalClient() && TextAnimatorClient.getTypewriterMode() == TypewriterMode.BY_WORD;
        if (taStyle.textanimator$getTypewriterTrack() != null && (typingIndex = taStyle.textanimator$getTypewriterIndex()) == -1 && string.length() > 1) {
            Locale locale = CommonProxy.getLocale();
            BreakIterator breakIterator = byWord ? BreakIterator.getLineInstance(locale) : BreakIterator.getCharacterInstance(locale);
            sb = new StringBuilder();
            StringDecomposer.m_14306_((String)string, (int)i, (Style)Style.f_131099_, (index, style1, codePoint) -> {
                sb.appendCodePoint(codePoint);
                return true;
            });
            breakIterator.setText(sb.toString());
            boundaries = new IntArrayList();
            int start = breakIterator.first();
            int end = breakIterator.next();
            while (end != -1) {
                boundaries.add(i + start);
                start = end;
                end = breakIterator.next();
            }
            typingIndex = i;
        }
        block3: for (int k = i; k < j; ++k) {
            char c = string.charAt(k);
            if (!boundaries.isEmpty() && charsEaten >= boundaries.getInt(0)) {
                int n = byWord ? Mth.m_14045_((int)(charsEaten - lastBoundary), (int)1, (int)5) : 1;
                lastBoundary = boundaries.removeInt(0);
                curStyle = CommonProxy.clone(curStyle);
                ((TAStyle)curStyle).textanimator$setTypewriterIndex(typingIndex += n);
            }
            if (c == '\u00a7') {
                if (k + 1 >= j) break;
                char d = string.charAt(k + 1);
                ChatFormatting chatFormatting = ChatFormatting.m_126645_((char)d);
                if (chatFormatting != null) {
                    curStyle = chatFormatting == ChatFormatting.RESET ? plainStyle : curStyle.m_131164_(chatFormatting);
                }
                ++k;
                continue;
            }
            if (c == '<') {
                sb = new StringBuilder();
                for (int l = k + 1; l < j; ++l) {
                    char ch = string.charAt(l);
                    if (ch == '>') {
                        String[] split = StringUtils.split((String)sb.toString(), (char)' ');
                        if (split.length == 0 || split[0].isEmpty()) break;
                        ImmutableList newEffects = null;
                        ImmutableList<Effect> effects = ((TAStyle)curStyle).textanimator$getEffects();
                        if (split[0].charAt(0) == '/') {
                            String tagName = split[0].substring(1);
                            if (!effects.isEmpty() && ((Effect)effects.get(effects.size() - 1)).getName().equals(tagName)) {
                                newEffects = effects.subList(0, effects.size() - 1);
                            }
                        } else {
                            try {
                                Effect effect = Effect.create(split, false);
                                newEffects = ImmutableList.builder().addAll(effects).add((Object)effect).build();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (newEffects == null) break;
                        curStyle = CommonProxy.clone(curStyle);
                        ((TAStyle)curStyle).textanimator$setEffects((ImmutableList<Effect>)newEffects);
                        k = l;
                        continue block3;
                    }
                    sb.append(ch);
                }
            }
            ++charsEaten;
            if (Character.isHighSurrogate(c)) {
                if (k + 1 >= j) {
                    if (formattedCharSink.m_6411_(k, curStyle, 65533)) break;
                    return false;
                }
                char d = string.charAt(k + 1);
                if (Character.isLowSurrogate(d)) {
                    if (!formattedCharSink.m_6411_(k, curStyle, Character.toCodePoint(c, d))) {
                        return false;
                    }
                    ++k;
                    ++charsEaten;
                    continue;
                }
                if (formattedCharSink.m_6411_(k, curStyle, 65533)) continue;
                return false;
            }
            if (StringDecomposerAccess.callFeedChar(curStyle, formattedCharSink, k, c)) continue;
            return false;
        }
        return true;
    }

    public static Locale getLocale() {
        if (CommonProxy.isPhysicalClient()) {
            return ClientProxy.getLocale();
        }
        return Locale.getDefault();
    }

    public static void onEffectTypeRegistered(String type, Function<Params, Effect> factory) {
        if (CommonProxy.isPhysicalClient()) {
            ClientProxy.onEffectTypeRegistered(type, factory);
        }
    }

    public static boolean isPhysicalClient() {
        return FMLEnvironment.dist.isClient();
    }
}

