/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.effect;

import net.minecraft.Util;
import snownee.textanimator.effect.BaseEffect;
import snownee.textanimator.effect.EffectSettings;
import snownee.textanimator.effect.params.Params;

public class PendulumEffect
extends BaseEffect {
    private final float speed;
    private final float maxAngle;
    private final float radius;

    public PendulumEffect(Params params) {
        super(params);
        this.speed = (float)params.getDouble("f").orElse(1.0);
        this.maxAngle = (float)params.getDouble("a").orElse(30.0);
        this.radius = (float)params.getDouble("r").orElse(0.0);
    }

    @Override
    public void apply(EffectSettings settings) {
        long t = Util.m_137550_();
        double phase = (double)t * 0.002 * (double)this.speed - (double)settings.index * 0.1;
        float angleRad = (float)Math.toRadians(this.maxAngle);
        settings.pendRad = (float)(Math.sin(phase) * (double)angleRad);
        if (this.radius != 0.0f) {
            settings.x += (float)(Math.cos(phase) * (double)this.radius);
            settings.y += (float)(Math.sin(phase) * (double)this.radius);
        }
    }

    @Override
    public String getName() {
        return "pend";
    }
}

