/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.effect;

import snownee.textanimator.effect.BaseEffect;
import snownee.textanimator.effect.EffectSettings;
import snownee.textanimator.effect.params.Params;

public class ShadowEffect
extends BaseEffect {
    private final float dx;
    private final float dy;
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public ShadowEffect(Params params) {
        super(params);
        this.dx = (float)params.getDouble("x").orElse(0.0);
        this.dy = (float)params.getDouble("y").orElse(0.0);
        float[] color = ShadowEffect.parseColor(params, "c", null);
        if (color != null) {
            this.r = color[0];
            this.g = color[1];
            this.b = color[2];
        } else {
            this.r = (float)params.getDouble("r").orElse(0.0);
            this.g = (float)params.getDouble("g").orElse(0.0);
            this.b = (float)params.getDouble("b").orElse(0.0);
        }
        this.a = (float)params.getDouble("a").orElse(1.0);
    }

    @Override
    public void apply(EffectSettings settings) {
        if (!settings.isShadow) {
            return;
        }
        settings.x += this.dx;
        settings.y += this.dy;
        settings.r = this.r;
        settings.g = this.g;
        settings.b = this.b;
        settings.a *= this.a;
    }

    @Override
    public String getName() {
        return "shadow";
    }
}

