/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.mixin;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.network.chat.Style;
import net.minecraft.util.GsonHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.textanimator.duck.TAStyle;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.typewriter.TypewriterTrack;

@Mixin(value={Style.class})
public class StyleMixin
implements TAStyle {
    @Unique
    private ImmutableList<Effect> textanimator$effects = ImmutableList.of();
    @Unique
    private TypewriterTrack textanimator$track;
    @Unique
    private int textanimator$typewriterIndex = -1;

    @Override
    public ImmutableList<Effect> textanimator$getEffects() {
        return this.textanimator$effects;
    }

    @Override
    public void textanimator$setEffects(ImmutableList<Effect> effects) {
        this.textanimator$effects = effects;
    }

    @Override
    public void textanimator$addEffect(Effect effect) {
        this.textanimator$effects = this.textanimator$effects.isEmpty() ? ImmutableList.of((Object)effect) : ImmutableList.builder().addAll(this.textanimator$effects).add((Object)effect).build();
    }

    @Override
    public TypewriterTrack textanimator$getTypewriterTrack() {
        return this.textanimator$track;
    }

    @Override
    public void textanimator$setTypewriterTrack(TypewriterTrack track) {
        this.textanimator$track = track;
    }

    @Override
    public int textanimator$getTypewriterIndex() {
        return this.textanimator$typewriterIndex;
    }

    @Override
    public void textanimator$setTypewriterIndex(int index) {
        this.textanimator$typewriterIndex = index;
    }

    @ModifyReturnValue(method={"withColor(Lnet/minecraft/network/chat/TextColor;)Lnet/minecraft/network/chat/Style;", "withBold", "withItalic", "withUnderlined", "withStrikethrough", "withObfuscated", "withClickEvent", "withHoverEvent", "withInsertion", "withFont", "applyFormat", "applyLegacyFormat", "applyFormats"}, at={@At(value="RETURN")})
    private Style textanimator$applyTo(Style original) {
        Style self = (Style)this;
        if (self == original) {
            return original;
        }
        if (this.textanimator$getEffects().isEmpty() && this.textanimator$getTypewriterTrack() == null) {
            return original;
        }
        ((TAStyle)original).textanimator$setEffects(this.textanimator$getEffects());
        if (this.textanimator$getTypewriterTrack() != null) {
            ((TAStyle)original).textanimator$setTypewriterTrack(this.textanimator$getTypewriterTrack());
            ((TAStyle)original).textanimator$setTypewriterIndex(this.textanimator$getTypewriterIndex());
        }
        return original;
    }

    @ModifyReturnValue(method={"applyTo"}, at={@At(value="RETURN")})
    private Style textanimator$applyTo(Style original, Style that) {
        Style self = (Style)this;
        if (self == original || that == original) {
            return original;
        }
        ImmutableList<Effect> effects = this.textanimator$getEffects();
        TypewriterTrack track = this.textanimator$getTypewriterTrack();
        int index = this.textanimator$getTypewriterIndex();
        TAStyle thatStyle = (TAStyle)that;
        ImmutableList<Effect> thatEffects = thatStyle.textanimator$getEffects();
        TypewriterTrack thatTrack = thatStyle.textanimator$getTypewriterTrack();
        int thatIndex = thatStyle.textanimator$getTypewriterIndex();
        TAStyle originalStyle = (TAStyle)original;
        originalStyle.textanimator$setEffects(effects.isEmpty() ? thatEffects : effects);
        originalStyle.textanimator$setTypewriterTrack(track == null ? thatTrack : track);
        originalStyle.textanimator$setTypewriterIndex(index == -1 ? thatIndex : index);
        return original;
    }

    @Inject(method={"equals"}, at={@At(value="HEAD")}, cancellable=true)
    private void textanimator$equals(Object obj, CallbackInfoReturnable<Boolean> cir) {
        if (this != obj && obj instanceof TAStyle) {
            TAStyle style = (TAStyle)obj;
            if (!Objects.equals(this.textanimator$getEffects(), style.textanimator$getEffects())) {
                cir.setReturnValue((Object)false);
            }
            if (!Objects.equals(this.textanimator$getTypewriterTrack(), style.textanimator$getTypewriterTrack())) {
                cir.setReturnValue((Object)false);
            }
            if (this.textanimator$getTypewriterIndex() != style.textanimator$getTypewriterIndex()) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Mixin(value={Style.Serializer.class})
    public static class SerializerMixin {
        @Inject(method={"deserialize"}, at={@At(value="RETURN")})
        private void textanimator$deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext, CallbackInfoReturnable<Style> cir) {
            if (!jsonElement.isJsonObject() || cir.getReturnValue() == null) {
                return;
            }
            JsonObject json = jsonElement.getAsJsonObject();
            if (!json.has("ta$effects")) {
                return;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            GsonHelper.m_13933_((JsonObject)json, (String)"ta$effects").forEach(e -> {
                try {
                    builder.add((Object)Effect.create(e.getAsString(), true));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            ((TAStyle)cir.getReturnValue()).textanimator$setEffects((ImmutableList<Effect>)builder.build());
        }

        @Inject(method={"serialize"}, at={@At(value="RETURN")})
        private void textanimator$serialize(Style style, Type type, JsonSerializationContext jsonSerializationContext, CallbackInfoReturnable<JsonElement> cir) {
            JsonElement jsonElement = (JsonElement)cir.getReturnValue();
            TAStyle taStyle = (TAStyle)style;
            if (jsonElement == null || !jsonElement.isJsonObject() || taStyle.textanimator$getEffects().isEmpty()) {
                return;
            }
            JsonObject json = jsonElement.getAsJsonObject();
            JsonArray array = new JsonArray();
            taStyle.textanimator$getEffects().forEach(e -> array.add(e.serialize()));
            json.add("ta$effects", (JsonElement)array);
        }
    }
}

