/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.mixin.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.textanimator.TextAnimationMode;
import snownee.textanimator.TextAnimatorClient;
import snownee.textanimator.duck.TABakedGlyph;
import snownee.textanimator.duck.TAStyle;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.effect.EffectSettings;
import snownee.textanimator.effect.NeonEffect;
import snownee.textanimator.mixin.client.FontAccess;
import snownee.textanimator.typewriter.TypewriterTrack;

@Mixin(value={Font.StringRenderOutput.class}, priority=1200)
public abstract class StringRenderOutputMixin {
    @Shadow
    @Final
    private Matrix4f f_92945_;
    @Final
    @Shadow
    MultiBufferSource f_92937_;
    @Shadow
    float f_92948_;
    @Shadow
    float f_92949_;
    @Final
    @Shadow(remap=false, aliases={"f_92938_", "field_24240", "b"})
    Font this$0;
    @Final
    @Shadow
    private boolean f_92939_;
    @Final
    @Shadow
    private float f_92940_;
    @Final
    @Shadow
    private float f_92944_;
    @Final
    @Shadow
    private float f_92943_;
    @Final
    @Shadow
    private float f_92941_;
    @Final
    @Shadow
    private float f_92942_;
    @Final
    @Shadow
    private Font.DisplayMode f_181362_;
    @Final
    @Shadow
    private int f_92947_;

    @Inject(method={"accept"}, at={@At(value="HEAD")}, cancellable=true)
    private void textanimator$accept(int index, Style style, int codepoint, CallbackInfoReturnable<Boolean> cir) {
        float shadowOffset;
        float b;
        float g;
        float r;
        TAStyle taStyle = (TAStyle)style;
        if (taStyle.textanimator$getEffects().isEmpty()) {
            return;
        }
        FontSet fontSet = ((FontAccess)this.this$0).callGetFontSet(style.m_131192_());
        GlyphInfo glyphInfo = fontSet.m_243128_(codepoint, ((FontAccess)this.this$0).getFilterFishyGlyphs());
        BakedGlyph bakedGlyph = style.m_131176_() && codepoint != 32 ? fontSet.m_95067_(glyphInfo) : fontSet.m_95078_(codepoint);
        float a = this.f_92944_;
        TextColor textColor = style.m_131135_();
        if (textColor != null) {
            int k = textColor.m_131265_();
            r = (float)(k >> 16 & 0xFF) / 255.0f * this.f_92940_;
            g = (float)(k >> 8 & 0xFF) / 255.0f * this.f_92940_;
            b = (float)(k & 0xFF) / 255.0f * this.f_92940_;
        } else {
            r = this.f_92941_;
            g = this.f_92942_;
            b = this.f_92943_;
        }
        float f = shadowOffset = this.f_92939_ ? glyphInfo.m_5645_() : 0.0f;
        if (!(bakedGlyph instanceof EmptyGlyph)) {
            TypewriterTrack typewriterTrack = taStyle.textanimator$getTypewriterTrack();
            int typingIndex = taStyle.textanimator$getTypewriterIndex();
            EffectSettings settings = new EffectSettings(codepoint, index + Math.max(typingIndex, 0), this.f_92939_, typewriterTrack, typingIndex);
            settings.x = this.f_92948_ + shadowOffset;
            settings.y = this.f_92949_ + shadowOffset;
            settings.r = r;
            settings.g = g;
            settings.b = b;
            settings.a = a;
            settings.shadowOffset = shadowOffset;
            settings.siblings = Lists.newArrayList((Object[])new EffectSettings[]{settings});
            TextAnimationMode animationMode = TextAnimatorClient.getTextAnimationMode();
            for (int i = taStyle.textanimator$getEffects().size() - 1; i >= 0; --i) {
                Effect effect = (Effect)taStyle.textanimator$getEffects().get(i);
                if (!animationMode.shouldApply(effect)) continue;
                int size = settings.siblings.size();
                for (int j = 0; j < size; ++j) {
                    effect.apply(settings.siblings.get(j));
                }
            }
            for (EffectSettings sibling : settings.siblings) {
                this.textanimator$renderChar(sibling, codepoint, style, fontSet, glyphInfo, bakedGlyph);
            }
            r = settings.r;
            g = settings.g;
            b = settings.b;
            a = settings.a;
        }
        float glyphWidth = glyphInfo.m_83827_(style.m_131154_());
        if (a != 0.0f && style.m_131168_()) {
            this.m_92964_(new BakedGlyph.Effect(this.f_92948_ + shadowOffset - 1.0f, this.f_92949_ + shadowOffset + 4.5f, this.f_92948_ + shadowOffset + glyphWidth, this.f_92949_ + shadowOffset + 4.5f - 1.0f, 0.01f, r, g, b, a));
        }
        if (a != 0.0f && style.m_131171_()) {
            this.m_92964_(new BakedGlyph.Effect(this.f_92948_ + shadowOffset - 1.0f, this.f_92949_ + shadowOffset + 9.0f, this.f_92948_ + shadowOffset + glyphWidth, this.f_92949_ + shadowOffset + 9.0f - 1.0f, 0.01f, r, g, b, a));
        }
        this.f_92948_ += glyphWidth;
        cir.setReturnValue((Object)true);
    }

    @Unique
    private void textanimator$renderChar(EffectSettings settings, int oCodepoint, Style style, FontSet fontSet, GlyphInfo glyphInfo, BakedGlyph bakedGlyph) {
        if (settings.a == 0.0f) {
            return;
        }
        if (settings.codepoint != oCodepoint && (bakedGlyph = fontSet.m_95078_(settings.codepoint)) instanceof EmptyGlyph) {
            return;
        }
        VertexConsumer vertexConsumer = this.f_92937_.m_6299_(bakedGlyph.m_181387_(this.f_181362_));
        Matrix4f pose = this.f_92945_;
        if (settings.rot != 0.0f) {
            glyphWidth = glyphInfo.m_83827_(style.m_131154_());
            float f = settings.rot;
            float f2 = glyphWidth / 2.0f;
            Objects.requireNonNull(this.this$0);
            pose = TextAnimatorClient.rotate(pose, settings, f, f2, 9.0f / 2.0f);
        } else if (settings.pendRad != 0.0f) {
            glyphWidth = glyphInfo.m_83827_(style.m_131154_());
            pose = TextAnimatorClient.rotate(pose, settings, settings.pendRad, glyphWidth / 2.0f, 0.0f);
        }
        TABakedGlyph glyph = (TABakedGlyph)bakedGlyph;
        glyph.textanimator$render(settings, style.m_131161_(), 0.0f, pose, vertexConsumer, this.f_92947_);
        if (style.m_131154_()) {
            glyph.textanimator$render(settings, style.m_131161_(), glyphInfo.m_5619_(), pose, vertexConsumer, this.f_92947_);
        }
        float boldOffset = style.m_131154_() ? glyphInfo.m_5619_() : 0.0f;
        TAStyle taStyle = (TAStyle)style;
        TextAnimationMode animationMode = TextAnimatorClient.getTextAnimationMode();
        for (Effect effect : taStyle.textanimator$getEffects()) {
            if (!(effect instanceof NeonEffect)) continue;
            NeonEffect neonEffect = (NeonEffect)effect;
            if (!animationMode.shouldApply(effect)) continue;
            TextAnimatorClient.renderNeonEffect(neonEffect, bakedGlyph, style.m_131154_(), style.m_131161_(), boldOffset, settings, pose, vertexConsumer, settings.r, settings.g, settings.b, settings.a, this.f_92947_);
        }
    }

    @Shadow
    protected abstract void m_92964_(BakedGlyph.Effect var1);
}

