/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_3532;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import org.apache.commons.lang3.StringUtils;
import snownee.textanimator.TextAnimator;
import snownee.textanimator.TextAnimatorApi;
import snownee.textanimator.TextAnimatorClient;
import snownee.textanimator.TypewriterMode;
import snownee.textanimator.duck.TAStyle;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.effect.EffectFactory;
import snownee.textanimator.effect.params.Params;
import snownee.textanimator.mixin.StringDecomposerAccess;
import snownee.textanimator.util.ClientProxy;

public class CommonProxy
implements ModInitializer {
    public static class_2583 clone(class_2583 style) {
        class_2583 copy = new class_2583(style.method_10973(), Boolean.valueOf(style.method_10984()), Boolean.valueOf(style.method_10966()), Boolean.valueOf(style.method_10965()), Boolean.valueOf(style.method_10986()), Boolean.valueOf(style.method_10987()), style.method_10970(), style.method_10969(), style.method_10955(), style.method_27708());
        ((TAStyle)copy).textanimator$setEffects(((TAStyle)style).textanimator$getEffects());
        ((TAStyle)copy).textanimator$setTypewriterTrack(((TAStyle)style).textanimator$getTypewriterTrack());
        ((TAStyle)copy).textanimator$setTypewriterIndex(((TAStyle)style).textanimator$getTypewriterIndex());
        return copy;
    }

    public static boolean iterateFormatted(String string, int i, class_2583 style, class_2583 plainStyle, class_5224 formattedCharSink) {
        StringBuilder sb;
        boolean byWord;
        int j = string.length();
        class_2583 curStyle = style;
        int typingIndex = -1;
        int lastBoundary = i;
        int charsEaten = i;
        IntList boundaries = IntList.of();
        TAStyle taStyle = (TAStyle)style;
        boolean bl = byWord = CommonProxy.isPhysicalClient() && TextAnimatorClient.getTypewriterMode() == TypewriterMode.BY_WORD;
        if (taStyle.textanimator$getTypewriterTrack() != null && (typingIndex = taStyle.textanimator$getTypewriterIndex()) == -1 && string.length() > 1) {
            Locale locale = CommonProxy.getLocale();
            BreakIterator breakIterator = byWord ? BreakIterator.getLineInstance(locale) : BreakIterator.getCharacterInstance(locale);
            sb = new StringBuilder();
            class_5223.method_27472((String)string, (int)i, (class_2583)class_2583.field_24360, (index, style1, codePoint) -> {
                sb.appendCodePoint(codePoint);
                return true;
            });
            breakIterator.setText(sb.toString());
            boundaries = new IntArrayList();
            int start = breakIterator.first();
            int end = breakIterator.next();
            while (end != -1) {
                boundaries.add(i + start);
                start = end;
                end = breakIterator.next();
            }
            typingIndex = i;
        }
        block3: for (int k = i; k < j; ++k) {
            char c = string.charAt(k);
            if (!boundaries.isEmpty() && charsEaten >= boundaries.getInt(0)) {
                int n = byWord ? class_3532.method_15340((int)(charsEaten - lastBoundary), (int)1, (int)5) : 1;
                lastBoundary = boundaries.removeInt(0);
                curStyle = CommonProxy.clone(curStyle);
                ((TAStyle)curStyle).textanimator$setTypewriterIndex(typingIndex += n);
            }
            if (c == '\u00a7') {
                if (k + 1 >= j) break;
                char d = string.charAt(k + 1);
                class_124 chatFormatting = class_124.method_544((char)d);
                if (chatFormatting != null) {
                    curStyle = chatFormatting == class_124.field_1070 ? plainStyle : curStyle.method_27707(chatFormatting);
                }
                ++k;
                continue;
            }
            if (c == '<' && !TextAnimatorApi.isParsingSuspended()) {
                sb = new StringBuilder();
                for (int l = k + 1; l < j; ++l) {
                    char ch = string.charAt(l);
                    if (ch == '>') {
                        String[] split = StringUtils.split((String)sb.toString(), (char)' ');
                        if (split.length == 0 || split[0].isEmpty()) break;
                        ImmutableList newEffects = null;
                        ImmutableList<Effect> effects = ((TAStyle)curStyle).textanimator$getEffects();
                        if (split[0].charAt(0) == '/') {
                            String tagName = split[0].substring(1);
                            if (!effects.isEmpty() && ((Effect)effects.get(effects.size() - 1)).getName().equals(tagName)) {
                                newEffects = effects.subList(0, effects.size() - 1);
                            }
                        } else {
                            try {
                                Effect effect = Effect.create(split, false);
                                newEffects = ImmutableList.builder().addAll(effects).add((Object)effect).build();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (newEffects == null) break;
                        curStyle = CommonProxy.clone(curStyle);
                        ((TAStyle)curStyle).textanimator$setEffects((ImmutableList<Effect>)newEffects);
                        k = l;
                        continue block3;
                    }
                    sb.append(ch);
                }
            }
            ++charsEaten;
            if (Character.isHighSurrogate(c)) {
                if (k + 1 >= j) {
                    if (formattedCharSink.accept(k, curStyle, 65533)) break;
                    return false;
                }
                char d = string.charAt(k + 1);
                if (Character.isLowSurrogate(d)) {
                    if (!formattedCharSink.accept(k, curStyle, Character.toCodePoint(c, d))) {
                        return false;
                    }
                    ++k;
                    ++charsEaten;
                    continue;
                }
                if (formattedCharSink.accept(k, curStyle, 65533)) continue;
                return false;
            }
            if (StringDecomposerAccess.callFeedChar(curStyle, formattedCharSink, k, c)) continue;
            return false;
        }
        return true;
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static void onEffectTypeRegistered(String type, Function<Params, Effect> factory) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientProxy.onEffectTypeRegistered(type, factory);
        }
    }

    public static String stripEffectTags(String input) {
        int close;
        int open;
        if (input == null || input.isEmpty()) {
            return input;
        }
        int start = 0;
        StringBuilder builder = null;
        while ((open = input.indexOf(60, start)) != -1 && (close = input.indexOf(62, open + 1)) != -1) {
            String content = input.substring(open + 1, close);
            boolean remove = false;
            if (!content.isEmpty()) {
                if (content.charAt(0) == '/') {
                    String type = content.substring(1);
                    remove = EffectFactory.listTypes().contains(type);
                } else {
                    try {
                        Effect.create(content, true);
                        remove = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (remove) {
                if (builder == null) {
                    builder = new StringBuilder(input.length());
                }
                builder.append(input, start, open);
                start = close + 1;
                continue;
            }
            if (builder != null) {
                builder.append(input, start, close + 1);
            }
            start = close + 1;
        }
        if (builder == null) {
            return input;
        }
        builder.append(input, start, input.length());
        return builder.toString();
    }

    public static boolean isPhysicalClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public void onInitialize() {
        TextAnimator.init();
    }
}

