/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import oshi.util.tuples.Pair;

@Environment(value=EnvType.CLIENT)
public class SpeedCalculator {
    public static String speedText(double speed) {
        return String.format("%.2f blocks/sec", SpeedCalculator.blocksPerSecond(speed));
    }

    public static String ssjText(double speed, int jumps) {
        return String.format("%.2f", SpeedCalculator.blocksPerSecond(speed)) + " (" + jumps + ")";
    }

    public static String effText(double percentage) {
        return String.format("%.2f", percentage) + "%";
    }

    public static Pair<String, Integer> gaugeText(double gauge, boolean horizontal) {
        if (horizontal) {
            int right_amount = 0;
            int left_amount = 0;
            if (gauge < 0.0) {
                i = 0;
                while ((double)i > gauge && left_amount < 4) {
                    ++left_amount;
                    i -= 10;
                }
            } else if (gauge > 0.0) {
                i = 0;
                while ((double)i < gauge && right_amount < 4) {
                    ++right_amount;
                    i += 10;
                }
            }
            String gaugeString = "<" + "-".repeat(Math.max(0, left_amount)) + "+" + "-".repeat(Math.max(0, right_amount)) + ">";
            int offsetToO = Math.max(0, left_amount);
            if (offsetToO == 0) {
                offsetToO = -Math.max(0, right_amount);
            }
            return new Pair((Object)gaugeString, (Object)offsetToO);
        }
        int up_amount = 0;
        int down_amount = 0;
        if (gauge < 0.0) {
            i = 0;
            while ((double)i > gauge && down_amount < 4) {
                ++down_amount;
                i -= 10;
            }
        } else if (gauge > 0.0) {
            i = 0;
            while ((double)i < gauge && up_amount < 4) {
                ++up_amount;
                i += 10;
            }
        }
        String gaugeString = "/\\" + "\n|  |".repeat(Math.max(0, up_amount)) + "\n++" + "\n|  |".repeat(Math.max(0, down_amount)) + "\n\\/";
        int offsetToO = 1 + Math.max(0, up_amount);
        return new Pair((Object)gaugeString, (Object)offsetToO);
    }

    private static double blocksPerSecond(double speed) {
        return speed / (double)0.05f;
    }
}

