/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.nerdorg.minehop.Minehop;
import net.nerdorg.minehop.commands.SpectateCommands;
import net.nerdorg.minehop.data.DataManager;
import net.nerdorg.minehop.entity.custom.EndEntity;
import net.nerdorg.minehop.entity.custom.ResetEntity;
import net.nerdorg.minehop.entity.custom.StartEntity;
import net.nerdorg.minehop.entity.custom.Zone;
import net.nerdorg.minehop.item.ModItems;
import net.nerdorg.minehop.networking.PacketHandler;
import net.nerdorg.minehop.util.Logger;
import net.nerdorg.minehop.util.StringFormatting;

public class MapUtilCommands {
    private static Random random = new Random();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"map").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            MapUtilCommands.handleTeleport((CommandContext<class_2168>)context);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"restart").executes(context -> {
            MapUtilCommands.handleRestart((CommandContext<class_2168>)context);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"list").executes(context -> {
            MapUtilCommands.handleList((CommandContext<class_2168>)context);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"top").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).executes(context -> {
            MapUtilCommands.handleListTop((CommandContext<class_2168>)context);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"manage").requires(source -> source.method_9259(4))).then(LiteralArgumentBuilder.literal((String)"checkpoint").then(LiteralArgumentBuilder.literal((String)"add").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).executes(context -> {
            MapUtilCommands.handleAddCheckpoint((CommandContext<class_2168>)context);
            return 1;
        }))))).then(LiteralArgumentBuilder.literal((String)"add").then(RequiredArgumentBuilder.argument((String)"add_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            MapUtilCommands.handleAdd((CommandContext<class_2168>)context);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"invalidate").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).executes(context -> {
            MapUtilCommands.handleInvalidate((CommandContext<class_2168>)context);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"invalidate_player").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).then(RequiredArgumentBuilder.argument((String)"player_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            MapUtilCommands.handleInvalidatePlayer((CommandContext<class_2168>)context);
            return 1;
        }))))).then(LiteralArgumentBuilder.literal((String)"remove").then(RequiredArgumentBuilder.argument((String)"remove_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).executes(context -> {
            MapUtilCommands.handleRemove((CommandContext<class_2168>)context);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"setspawn").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).executes(context -> {
            MapUtilCommands.handleSetMapSpawn((CommandContext<class_2168>)context);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"difficulty").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).then(RequiredArgumentBuilder.argument((String)"difficulty", (ArgumentType)IntegerArgumentType.integer()).suggests((context, builder) -> {
            builder.suggest(0, (Message)new LiteralMessage("Beginner"));
            builder.suggest(1, (Message)new LiteralMessage("Easy"));
            builder.suggest(2, (Message)new LiteralMessage("Moderate"));
            builder.suggest(3, (Message)new LiteralMessage("Challenging"));
            builder.suggest(4, (Message)new LiteralMessage("Extremely Hard"));
            builder.suggest(5, (Message)new LiteralMessage("Impossible"));
            return builder.buildFuture();
        }).executes(context -> {
            MapUtilCommands.handleSetDifficulty((CommandContext<class_2168>)context);
            return 1;
        }))))).then(LiteralArgumentBuilder.literal((String)"arena").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).executes(context -> {
            MapUtilCommands.handleToggleArena((CommandContext<class_2168>)context);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"hns").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).executes(context -> {
            MapUtilCommands.handleToggleHNS((CommandContext<class_2168>)context);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"info").then(RequiredArgumentBuilder.argument((String)"search_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            MapUtilCommands.handleInfo((CommandContext<class_2168>)context);
            return 1;
        }))))).executes(context -> {
            MapUtilCommands.handleOpenMapScreen((CommandContext<class_2168>)context);
            return 1;
        })));
    }

    private static void handleOpenMapScreen(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        PacketHandler.sendOpenMapScreen(serverPlayerEntity, "Balls");
    }

    private static void handleAddCheckpoint(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        DataManager.MapData mapToAddTo = null;
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (!mapData.name.equals(name)) continue;
            mapToAddTo = mapData;
            break;
        }
        if (mapToAddTo != null) {
            if (mapToAddTo.checkpointPositions == null) {
                mapToAddTo.checkpointPositions = new ArrayList<List<class_243>>();
            }
            Logger.logSuccess((class_1657)serverPlayerEntity, "Added checkpoint " + (mapToAddTo.checkpointPositions.size() + 1) + " to " + name);
            Minehop.mapList.remove(mapToAddTo);
            mapToAddTo.checkpointPositions.add(new ArrayList<class_243>(Arrays.asList(serverPlayerEntity.method_19538(), new class_243((double)serverPlayerEntity.method_5802().field_1343, (double)serverPlayerEntity.method_5802().field_1342, 0.0))));
            Minehop.mapList.add(mapToAddTo);
            DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_maps.json", Minehop.mapList);
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "The map " + name + " does not exist.");
        }
    }

    private static void handleRestart(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        assert (serverPlayerEntity != null);
        Zone closestEntity = Minehop.playerMapLocation.get(serverPlayerEntity.method_5845());
        if (closestEntity == null) {
            Logger.logFailure((class_1657)serverPlayerEntity, "Error finding nearest map.");
        } else {
            DataManager.MapData currentMapData = null;
            String mapName = "";
            if (closestEntity instanceof ResetEntity) {
                ResetEntity resetEntity = (ResetEntity)closestEntity;
                mapName = resetEntity.getPairedMap();
            } else if (closestEntity instanceof StartEntity) {
                StartEntity startEntity = (StartEntity)closestEntity;
                mapName = startEntity.getPairedMap();
            } else if (closestEntity instanceof EndEntity) {
                EndEntity endEntity = (EndEntity)closestEntity;
                mapName = endEntity.getPairedMap();
            }
            for (Object e : Minehop.mapList) {
                if (!(e instanceof DataManager.MapData)) continue;
                DataManager.MapData mapData = (DataManager.MapData)e;
                if (!mapData.name.equals(mapName)) continue;
                currentMapData = mapData;
                break;
            }
            if (currentMapData != null) {
                if (currentMapData.worldKey == null || currentMapData.worldKey.equals("")) {
                    Minehop.mapList.remove(currentMapData);
                    currentMapData.worldKey = ((class_2168)context.getSource()).method_9211().method_30002().method_27983().toString();
                    Minehop.mapList.add(currentMapData);
                    DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_maps.json", Minehop.mapList);
                }
                Minehop.timerManager.remove(serverPlayerEntity.method_5820());
                class_3218 foundWorld = null;
                for (class_3218 svrWorld : ((class_2168)context.getSource()).method_9211().method_3738()) {
                    if (!svrWorld.method_27983().toString().equals(currentMapData.worldKey)) continue;
                    foundWorld = svrWorld;
                    break;
                }
                if (foundWorld != null && !serverPlayerEntity.method_7325()) {
                    if (!serverPlayerEntity.method_7337()) {
                        serverPlayerEntity.method_31548().method_5448();
                    }
                    serverPlayerEntity.method_14251(foundWorld, currentMapData.x, currentMapData.y, currentMapData.z, (float)currentMapData.yrot, (float)currentMapData.xrot);
                    if (SpectateCommands.spectatorList.containsKey(serverPlayerEntity.method_5820())) {
                        List<String> list = SpectateCommands.spectatorList.get(serverPlayerEntity.method_5820());
                        for (String spectator : list) {
                            if (spectator.equals(serverPlayerEntity.method_5820())) continue;
                            class_3222 spectatorPlayer = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(spectator);
                            if (!spectatorPlayer.method_7337()) {
                                spectatorPlayer.method_31548().method_5448();
                            }
                            spectatorPlayer.method_20620(serverPlayerEntity.method_23317(), serverPlayerEntity.method_23318(), serverPlayerEntity.method_23321());
                            spectatorPlayer.method_14224((class_1297)serverPlayerEntity);
                        }
                    }
                }
            } else {
                Logger.logFailure((class_1657)serverPlayerEntity, "Error finding nearest map.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void handleTeleport(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        DataManager.MapData tpData = null;
        for (DataManager.MapData mapData : Minehop.mapList) {
            if (!(mapData instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData2 = mapData;
            if (!mapData2.name.equals(name)) continue;
            tpData = mapData2;
            break;
        }
        if (tpData != null) {
            if (tpData.worldKey == null || tpData.worldKey.equals("")) {
                Minehop.mapList.remove(tpData);
                tpData.worldKey = ((class_2168)context.getSource()).method_9211().method_30002().method_27983().toString();
                Minehop.mapList.add(tpData);
                DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_maps.json", Minehop.mapList);
            }
            Logger.logSuccess((class_1657)serverPlayerEntity, "Teleporting to " + name);
            class_3218 foundWorld = null;
            for (class_3218 serverWorld : ((class_2168)context.getSource()).method_9211().method_3738()) {
                if (!serverWorld.method_27983().toString().equals(tpData.worldKey)) continue;
                foundWorld = serverWorld;
                break;
            }
            if (foundWorld != null) {
                class_243 class_2432 = new class_243(tpData.x, tpData.y, tpData.z);
                class_243 rotPos = new class_243(tpData.xrot, tpData.yrot, 0.0);
                if (tpData.arena) {
                    ArrayList<class_243> spawnCheck = new ArrayList<class_243>();
                    spawnCheck.add(new class_243(tpData.x, tpData.y, tpData.z));
                    spawnCheck.add(new class_243(tpData.xrot, tpData.yrot, 0.0));
                    ArrayList<List<class_243>> checkpointPositions = new ArrayList<List<class_243>>();
                    if (tpData.checkpointPositions != null) {
                        checkpointPositions.addAll(tpData.checkpointPositions);
                    }
                    checkpointPositions.add(spawnCheck);
                    List randomCheckpoint = (List)checkpointPositions.get(random.nextInt(0, checkpointPositions.size()));
                    class_243 class_2433 = (class_243)randomCheckpoint.get(0);
                    rotPos = (class_243)randomCheckpoint.get(1);
                }
                if (!serverPlayerEntity.method_7325()) {
                    void var5_9;
                    if (!serverPlayerEntity.method_7337()) {
                        serverPlayerEntity.method_31548().method_5448();
                    }
                    serverPlayerEntity.method_14251(foundWorld, var5_9.method_10216(), var5_9.method_10214(), var5_9.method_10215(), (float)rotPos.method_10214(), (float)rotPos.method_10216());
                    if (SpectateCommands.spectatorList.containsKey(serverPlayerEntity.method_5820())) {
                        List<String> spectators = SpectateCommands.spectatorList.get(serverPlayerEntity.method_5820());
                        for (String spectator : spectators) {
                            if (spectator.equals(serverPlayerEntity.method_5820())) continue;
                            class_3222 spectatorPlayer = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(spectator);
                            if (!spectatorPlayer.method_7337()) {
                                spectatorPlayer.method_31548().method_5448();
                            }
                            spectatorPlayer.method_20620(serverPlayerEntity.method_23317(), serverPlayerEntity.method_23318(), serverPlayerEntity.method_23321());
                            spectatorPlayer.method_14224((class_1297)serverPlayerEntity);
                        }
                    }
                    if (tpData.arena) {
                        for (int slotNum = 1; slotNum < serverPlayerEntity.method_31548().method_5439(); ++slotNum) {
                            serverPlayerEntity.method_31548().method_5447(slotNum, new class_1799((class_1935)class_1802.field_8162));
                        }
                        serverPlayerEntity.method_31548().method_5447(0, new class_1799((class_1935)ModItems.INSTAGIB_GUN));
                    }
                }
            }
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "The map " + name + " does not exist.");
        }
    }

    private static void handleAdd(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"add_name");
        double spawn_x = serverPlayerEntity.method_23317();
        double spawn_y = serverPlayerEntity.method_23318();
        double spawn_z = serverPlayerEntity.method_23321();
        double spawn_xrot = serverPlayerEntity.method_36455();
        double spawn_yrot = serverPlayerEntity.method_36454();
        DataManager.MapData mapData = new DataManager.MapData(name, spawn_x, spawn_y, spawn_z, spawn_xrot, spawn_yrot, serverPlayerEntity.method_37908().method_27983().toString());
        Minehop.mapList.add(mapData);
        DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_maps.json", Minehop.mapList);
        Logger.logSuccess((class_1657)serverPlayerEntity, "Created map \\/\n" + StringFormatting.limitDecimals(gson.toJson((Object)mapData)));
    }

    private static void handleInvalidatePlayer(CommandContext<class_2168> context) {
        class_3222 senderEntity = ((class_2168)context.getSource()).method_44023();
        String playerName = StringArgumentType.getString(context, (String)"player_name");
        String name = StringArgumentType.getString(context, (String)"map_name");
        DataManager.MapData invalidateData = null;
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (!mapData.name.equals(name)) continue;
            invalidateData = mapData;
            break;
        }
        if (invalidateData != null) {
            if (DataManager.getPersonalRecord(playerName, invalidateData.name) != null) {
                DataManager.removePersonalRecordsForPlayer(name, playerName);
                DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_pbs.json", Minehop.personalRecordList);
                DataManager.removeRecordsForPlayer(name, playerName);
                DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_records.json", Minehop.recordList);
                Logger.logSuccess((class_1657)senderEntity, "Invalidated times for player " + playerName + " on map \\/\n" + StringFormatting.limitDecimals(gson.toJson((Object)invalidateData)));
            } else {
                Logger.logFailure((class_1657)senderEntity, playerName + " does not have a time on " + invalidateData.name);
            }
        } else {
            Logger.logFailure((class_1657)senderEntity, "The map " + name + " does not exist.");
        }
    }

    private static void handleInvalidate(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        DataManager.MapData invalidateData = null;
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (!mapData.name.equals(name)) continue;
            invalidateData = mapData;
            break;
        }
        DataManager.removePersonalRecords(name);
        DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_pbs.json", Minehop.personalRecordList);
        DataManager.removeRecords(name);
        DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_records.json", Minehop.recordList);
        if (invalidateData != null) {
            Logger.logSuccess((class_1657)serverPlayerEntity, "Invalidated times for map \\/\n" + StringFormatting.limitDecimals(gson.toJson((Object)invalidateData)));
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "The map " + name + " does not exist.");
        }
    }

    private static void handleRemove(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"remove_name");
        DataManager.MapData removedData = null;
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (!mapData.name.equals(name)) continue;
            removedData = mapData;
            Minehop.mapList.remove(mapData);
            DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_maps.json", Minehop.mapList);
            break;
        }
        if (removedData != null) {
            Logger.logSuccess((class_1657)serverPlayerEntity, "Removed map \\/\n" + StringFormatting.limitDecimals(gson.toJson(removedData)));
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "The map " + name + " does not exist.");
        }
    }

    private static void handleSetDifficulty(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        int difficulty = IntegerArgumentType.getInteger(context, (String)"difficulty");
        DataManager.MapData difficultyData = null;
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (!mapData.name.equals(name)) continue;
            difficultyData = mapData;
            Minehop.mapList.remove(mapData);
            break;
        }
        if (difficultyData != null) {
            difficultyData.difficulty = difficulty;
            Minehop.mapList.add(difficultyData);
            DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_maps.json", Minehop.mapList);
            Logger.logSuccess((class_1657)serverPlayerEntity, "Set map difficulty \\/\n" + StringFormatting.limitDecimals(gson.toJson((Object)difficultyData)));
        } else {
            Logger.logSuccess((class_1657)serverPlayerEntity, "There is no map called " + name + ".");
        }
    }

    private static void handleSetMapSpawn(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        double spawn_x = serverPlayerEntity.method_23317();
        double spawn_y = serverPlayerEntity.method_23318();
        double spawn_z = serverPlayerEntity.method_23321();
        double spawn_xrot = serverPlayerEntity.method_36455();
        double spawn_yrot = serverPlayerEntity.method_36454();
        DataManager.MapData spawnData = null;
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (!mapData.name.equals(name)) continue;
            spawnData = mapData;
            Minehop.mapList.remove(mapData);
            break;
        }
        if (spawnData != null) {
            spawnData.x = spawn_x;
            spawnData.y = spawn_y;
            spawnData.z = spawn_z;
            spawnData.xrot = spawn_xrot;
            spawnData.yrot = spawn_yrot;
            Minehop.mapList.add(spawnData);
            DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_maps.json", Minehop.mapList);
            Logger.logSuccess((class_1657)serverPlayerEntity, "Set map spawn \\/\n" + StringFormatting.limitDecimals(gson.toJson((Object)spawnData)));
        } else {
            Logger.logSuccess((class_1657)serverPlayerEntity, "There is no map called " + name + ".");
        }
    }

    private static void handleToggleArena(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        DataManager.MapData toggleData = null;
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (!mapData.name.equals(name)) continue;
            toggleData = mapData;
            Minehop.mapList.remove(mapData);
            break;
        }
        if (toggleData != null) {
            toggleData.arena = !toggleData.arena;
            Minehop.mapList.add(toggleData);
            DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_maps.json", Minehop.mapList);
            Logger.logSuccess((class_1657)serverPlayerEntity, "Toggled arena mode to " + toggleData.arena);
        } else {
            Logger.logSuccess((class_1657)serverPlayerEntity, "There is no map called " + name + ".");
        }
    }

    private static void handleToggleHNS(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        DataManager.MapData toggleData = null;
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (!mapData.name.equals(name)) continue;
            toggleData = mapData;
            Minehop.mapList.remove(mapData);
            break;
        }
        if (toggleData != null) {
            toggleData.hns = !toggleData.hns;
            Minehop.mapList.add(toggleData);
            DataManager.saveData(((class_2168)context.getSource()).method_9225(), "MineHop_Data/minehop_maps.json", Minehop.mapList);
            Logger.logSuccess((class_1657)serverPlayerEntity, "Toggled hns mode to " + toggleData.hns);
        } else {
            Logger.logSuccess((class_1657)serverPlayerEntity, "There is no map called " + name + ".");
        }
    }

    private static void handleListTop(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        ArrayList<DataManager.RecordData> recordDataList = new ArrayList<DataManager.RecordData>();
        for (DataManager.RecordData recordData : Minehop.personalRecordList) {
            if (!recordData.map_name.equals(name)) continue;
            recordDataList.add(recordData);
        }
        HashMap<String, Double> formattedMap = new HashMap<String, Double>();
        for (DataManager.RecordData recordData : recordDataList) {
            formattedMap.put(recordData.name, recordData.time);
        }
        LinkedHashMap linkedHashMap = formattedMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        Logger.logSuccess((class_1657)serverPlayerEntity, "Top Map Times for " + name + " \\/\n" + StringFormatting.limitDecimals(gson.toJson((Object)linkedHashMap)));
    }

    private static void handleList(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        ArrayList<String> mapNameList = new ArrayList<String>();
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (mapData.name.equals("spawn")) continue;
            mapNameList.add(mapData.name);
        }
        Logger.logSuccess((class_1657)serverPlayerEntity, "Map Names \\/\n" + StringFormatting.limitDecimals(gson.toJson(mapNameList)) + "\nUse /map \"map_name\" in order to teleport.");
    }

    private static void handleInfo(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"search_name");
        DataManager.MapData foundData = null;
        for (DataManager.MapData object : Minehop.mapList) {
            if (!(object instanceof DataManager.MapData)) continue;
            DataManager.MapData mapData = object;
            if (!mapData.name.equals(name)) continue;
            foundData = mapData;
            break;
        }
        if (foundData != null) {
            Logger.logSuccess((class_1657)serverPlayerEntity, "Map Info \\/\n" + StringFormatting.limitDecimals(gson.toJson(foundData)));
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "The map " + name + " does not exist.");
        }
    }
}

