/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.server.MinecraftServer;
import net.nerdorg.minehop.data.DataManager;
import net.nerdorg.minehop.entity.ModEntities;
import net.nerdorg.minehop.entity.custom.ReplayEntity;
import net.nerdorg.minehop.replays.ReplayManager;

public class ReplayCommands {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"replay").requires(source -> source.method_9259(4))).then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ReplayCommands.handleAddReplay((CommandContext<class_2168>)context);
            return 1;
        }))));
    }

    private static void handleAddReplay(CommandContext<class_2168> context) {
        DataManager.MapData mapData;
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        String mapName = StringArgumentType.getString(context, (String)"map_name");
        ReplayManager.Replay replay = ReplayManager.getReplay(mapName);
        if (replay != null && (mapData = DataManager.getMap(mapName)) != null) {
            class_3218 foundWorld = null;
            for (class_3218 serverWorld : ((class_2168)context.getSource()).method_9211().method_3738()) {
                if (!serverWorld.method_27983().toString().equals(mapData.worldKey)) continue;
                foundWorld = serverWorld;
                break;
            }
            if (foundWorld != null) {
                ReplayEntity replayEntity = (ReplayEntity)ModEntities.REPLAY_ENTITY.method_47821(foundWorld, new class_2338((int)mapData.x, (int)mapData.y, (int)mapData.z), class_3730.field_16459);
                replayEntity.setMapName(mapName);
            }
        }
    }
}

