/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.commands;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.nerdorg.minehop.Minehop;
import net.nerdorg.minehop.commands.SpawnCommands;
import net.nerdorg.minehop.entity.custom.ReplayEntity;
import net.nerdorg.minehop.util.Logger;
import net.nerdorg.minehop.util.ZoneUtil;

public class SpectateCommands {
    public static HashMap<String, List<String>> spectatorList = new HashMap();

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"spec").then(RequiredArgumentBuilder.argument((String)"entity", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            Iterable entities = ((class_2168)context.getSource()).method_9225().method_27909();
            for (class_1297 entity : entities) {
                if (entity instanceof ReplayEntity) {
                    builder.suggest(entity.method_5820(), (Message)new LiteralMessage(entity.method_5477().getString()));
                    continue;
                }
                if (!(entity instanceof class_1657) || ((class_1657)entity).method_7337() || entity.method_7325()) continue;
                builder.suggest(entity.method_5820(), (Message)new LiteralMessage(entity.method_5477().getString()));
            }
            return builder.buildFuture();
        }).executes(context -> {
            SpectateCommands.handleSpectateReplay((CommandContext<class_2168>)context);
            return 1;
        }))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"spectate").then(RequiredArgumentBuilder.argument((String)"entity", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            Iterable entities = ((class_2168)context.getSource()).method_9225().method_27909();
            for (class_1297 entity : entities) {
                if (entity instanceof ReplayEntity) {
                    builder.suggest(entity.method_5820(), (Message)new LiteralMessage(entity.method_5477().getString()));
                    continue;
                }
                if (!(entity instanceof class_1657)) continue;
                builder.suggest(entity.method_5820(), (Message)new LiteralMessage(entity.method_5477().getString()));
            }
            return builder.buildFuture();
        }).executes(context -> {
            SpectateCommands.handleSpectateReplay((CommandContext<class_2168>)context);
            return 1;
        }))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"unspec").executes(context -> {
            SpectateCommands.handleUnSpectate((CommandContext<class_2168>)context);
            return 1;
        })));
    }

    private static void handleUnSpectate(CommandContext<class_2168> context) throws CommandSyntaxException {
        List<String> spectators;
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        if (serverPlayerEntity.method_14242() != null && spectatorList.containsKey(serverPlayerEntity.method_14242().method_5820()) && (spectators = spectatorList.get(serverPlayerEntity.method_14242().method_5820())).contains(serverPlayerEntity.method_5820())) {
            spectators.remove(serverPlayerEntity.method_5820());
        }
        if (Minehop.timerManager.containsKey(serverPlayerEntity.method_5820())) {
            Minehop.timerManager.remove(serverPlayerEntity.method_5820());
        }
        serverPlayerEntity.method_14224((class_1297)serverPlayerEntity);
        if (!serverPlayerEntity.method_7325()) {
            Logger.logFailure((class_1657)serverPlayerEntity, "You are not spectating.");
        } else {
            Logger.logSuccess((class_1657)serverPlayerEntity, "No longer spectating.");
            SpawnCommands.handleSpawn(context);
        }
        serverPlayerEntity.method_7336(class_1934.field_9216);
    }

    private static void handleSpectateReplay(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 entity;
        List<String> spectators;
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        if (serverPlayerEntity.method_14242() != null && spectatorList.containsKey(serverPlayerEntity.method_14242().method_5820()) && (spectators = spectatorList.get(serverPlayerEntity.method_14242().method_5820())).contains(serverPlayerEntity.method_5820())) {
            spectators.remove(serverPlayerEntity.method_5820());
        }
        if (Minehop.timerManager.containsKey(serverPlayerEntity.method_5820())) {
            Minehop.timerManager.remove(serverPlayerEntity.method_5820());
        }
        String nameString = new String(((String)context.getArgument("entity", String.class)).getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        if (Minehop.timerManager.containsKey(serverPlayerEntity.method_5820())) {
            Minehop.timerManager.remove(serverPlayerEntity.method_5820());
        }
        if ((entity = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(nameString)) == null) {
            Iterable entities = ((class_2168)context.getSource()).method_9225().method_27909();
            for (class_1297 iterEntity : entities) {
                if (!(iterEntity instanceof ReplayEntity) || !iterEntity.method_5820().equals(nameString)) continue;
                entity = iterEntity;
                break;
            }
            if (entity == null) {
                Logger.logFailure((class_1657)serverPlayerEntity, "Entity not found.");
                return;
            }
        }
        if (entity instanceof ReplayEntity) {
            ReplayEntity replayEntity = (ReplayEntity)entity;
            mapName = ZoneUtil.getCurrentMapName((class_1297)serverPlayerEntity);
            String replayName = replayEntity.method_5820();
            if (mapName != null) {
                if (replayName.startsWith(mapName)) {
                    serverPlayerEntity.method_14224((class_1297)serverPlayerEntity);
                    Logger.logSuccess((class_1657)serverPlayerEntity, "Now spectating " + replayEntity.method_5820() + ". Use /unspec to stop spectating.");
                    serverPlayerEntity.method_7336(class_1934.field_9219);
                    if (!serverPlayerEntity.method_7337()) {
                        serverPlayerEntity.method_31548().method_5448();
                    }
                    serverPlayerEntity.method_20620(replayEntity.method_23317(), replayEntity.method_23318(), replayEntity.method_23321());
                    serverPlayerEntity.method_14224((class_1297)replayEntity);
                } else {
                    Logger.logSuccess((class_1657)serverPlayerEntity, "Please teleport to the map before viewing it's replay.");
                }
            } else {
                Logger.logSuccess((class_1657)serverPlayerEntity, "Please teleport to the map before viewing it's replay.");
            }
        } else if (entity instanceof class_3222) {
            class_3222 playerEntity = entity;
            if (playerEntity == serverPlayerEntity) {
                Logger.logFailure((class_1657)serverPlayerEntity, "You cannot spectate yourself.");
            } else if (playerEntity.method_7337() || playerEntity.method_7325()) {
                Logger.logFailure((class_1657)serverPlayerEntity, "You cannot spectate another spectator.");
            } else {
                String targetMapName;
                mapName = ZoneUtil.getCurrentMapName((class_1297)serverPlayerEntity);
                if (mapName.equals(targetMapName = ZoneUtil.getCurrentMapName((class_1297)playerEntity))) {
                    serverPlayerEntity.method_14224((class_1297)serverPlayerEntity);
                    Logger.logSuccess((class_1657)serverPlayerEntity, "Now spectating " + playerEntity.method_5820() + ". Use /unspec to stop spectating.");
                    serverPlayerEntity.method_7336(class_1934.field_9219);
                    if (!serverPlayerEntity.method_7337()) {
                        serverPlayerEntity.method_31548().method_5448();
                    }
                    serverPlayerEntity.method_20620(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321());
                    serverPlayerEntity.method_14224((class_1297)playerEntity);
                } else {
                    Logger.logSuccess((class_1657)serverPlayerEntity, "Please teleport to " + targetMapName + " before spectating this player.");
                }
            }
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "You cannot spectate this entity.");
        }
    }
}

