/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.nerdorg.minehop.Minehop;
import net.nerdorg.minehop.data.DataManager;
import net.nerdorg.minehop.entity.ModEntities;
import net.nerdorg.minehop.entity.custom.EndEntity;
import net.nerdorg.minehop.entity.custom.ResetEntity;
import net.nerdorg.minehop.entity.custom.StartEntity;
import net.nerdorg.minehop.entity.custom.Zone;
import net.nerdorg.minehop.item.custom.BoundsStickItem;
import net.nerdorg.minehop.networking.PacketHandler;
import net.nerdorg.minehop.util.Logger;

public class ZoneManagementCommands {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"zone").requires(source -> source.method_9259(4))).then(LiteralArgumentBuilder.literal((String)"kill").executes(context -> {
            ZoneManagementCommands.handleKill((CommandContext<class_2168>)context);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"add").then(LiteralArgumentBuilder.literal((String)"reset").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).then(RequiredArgumentBuilder.argument((String)"check_index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ZoneManagementCommands.handleAddResetCustom((CommandContext<class_2168>)context);
            return 1;
        }))).executes(context -> {
            ZoneManagementCommands.handleAddReset((CommandContext<class_2168>)context);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"start").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).executes(context -> {
            ZoneManagementCommands.handleAddStart((CommandContext<class_2168>)context);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"end").then(RequiredArgumentBuilder.argument((String)"map_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DataManager.MapData mapData : Minehop.mapList) {
                builder.suggest(mapData.name, (Message)new LiteralMessage(mapData.name));
            }
            return builder.buildFuture();
        }).executes(context -> {
            ZoneManagementCommands.handleAddEnd((CommandContext<class_2168>)context);
            return 1;
        }))))));
    }

    private static void handleKill(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        class_3218 serverWorld = serverPlayerEntity.method_51469();
        ArrayList<Zone> zoneEntities = new ArrayList<Zone>();
        for (class_1297 entity : serverWorld.method_27909()) {
            if (!(entity instanceof Zone)) continue;
            Zone zone = (Zone)entity;
            zoneEntities.add(zone);
        }
        double closestDistance = Double.POSITIVE_INFINITY;
        Zone closestEntity = null;
        for (Zone zoneEntity : zoneEntities) {
            double distance = zoneEntity.method_5739((class_1297)serverPlayerEntity);
            if (!(distance < closestDistance)) continue;
            closestEntity = zoneEntity;
            closestDistance = distance;
        }
        if (closestEntity != null) {
            closestEntity.method_5768();
            Logger.logSuccess((class_1657)serverPlayerEntity, "Killed nearest zone entity.");
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "Couldn't find zone entity within 10 blocks.");
        }
    }

    private static void handleAddResetCustom(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        int check_index = IntegerArgumentType.getInteger(context, (String)"check_index");
        DataManager.MapData pairedMap = DataManager.getMap(name);
        if (pairedMap != null) {
            class_3218 serverWorld = ((class_2168)context.getSource()).method_9225();
            if (BoundsStickItem.playerPositions.containsKey(serverPlayerEntity.method_5820())) {
                class_2338[] setPositions = BoundsStickItem.playerPositions.get(serverPlayerEntity.method_5820());
                if (setPositions[0] != null && setPositions[1] != null) {
                    ResetEntity resetEntity = (ResetEntity)ModEntities.RESET_ENTITY.method_47821(serverWorld, setPositions[0], class_3730.field_16459);
                    resetEntity.setCorner1(setPositions[0]);
                    resetEntity.setCorner2(setPositions[1]);
                    resetEntity.setPairedMap(name);
                    resetEntity.setCheckIndex(check_index);
                    for (class_3222 worldPlayer : serverWorld.method_18456()) {
                        PacketHandler.updateZone(worldPlayer, resetEntity.method_5628(), setPositions[0], setPositions[1], name, check_index);
                    }
                    Logger.logSuccess((class_1657)serverPlayerEntity, "Creating reset zone from " + setPositions[0].method_23854() + " to " + setPositions[1].method_23854());
                } else {
                    Logger.logFailure((class_1657)serverPlayerEntity, "You haven't set both corner positions.");
                }
            } else {
                Logger.logFailure((class_1657)serverPlayerEntity, "You need to set positions first.");
            }
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "There is no map called " + name + ".");
        }
    }

    private static void handleAddReset(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        DataManager.MapData pairedMap = DataManager.getMap(name);
        if (pairedMap != null) {
            class_3218 serverWorld = ((class_2168)context.getSource()).method_9225();
            if (BoundsStickItem.playerPositions.containsKey(serverPlayerEntity.method_5820())) {
                class_2338[] setPositions = BoundsStickItem.playerPositions.get(serverPlayerEntity.method_5820());
                if (setPositions[0] != null && setPositions[1] != null) {
                    ResetEntity resetEntity = (ResetEntity)ModEntities.RESET_ENTITY.method_47821(serverWorld, setPositions[0], class_3730.field_16459);
                    resetEntity.setCorner1(setPositions[0]);
                    resetEntity.setCorner2(setPositions[1]);
                    resetEntity.setPairedMap(name);
                    for (class_3222 worldPlayer : serverWorld.method_18456()) {
                        PacketHandler.updateZone(worldPlayer, resetEntity.method_5628(), setPositions[0], setPositions[1], name, 0);
                    }
                    Logger.logSuccess((class_1657)serverPlayerEntity, "Creating reset zone from " + setPositions[0].method_23854() + " to " + setPositions[1].method_23854());
                } else {
                    Logger.logFailure((class_1657)serverPlayerEntity, "You haven't set both corner positions.");
                }
            } else {
                Logger.logFailure((class_1657)serverPlayerEntity, "You need to set positions first.");
            }
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "There is no map called " + name + ".");
        }
    }

    private static void handleAddStart(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        DataManager.MapData pairedMap = DataManager.getMap(name);
        if (pairedMap != null) {
            class_3218 serverWorld = ((class_2168)context.getSource()).method_9225();
            if (BoundsStickItem.playerPositions.containsKey(serverPlayerEntity.method_5820())) {
                class_2338[] setPositions = BoundsStickItem.playerPositions.get(serverPlayerEntity.method_5820());
                if (setPositions[0] != null && setPositions[1] != null) {
                    StartEntity startEntity = (StartEntity)ModEntities.START_ENTITY.method_47821(serverWorld, setPositions[0], class_3730.field_16459);
                    startEntity.setCorner1(setPositions[0]);
                    startEntity.setCorner2(setPositions[1]);
                    startEntity.setPairedMap(name);
                    for (class_3222 worldPlayer : serverWorld.method_18456()) {
                        PacketHandler.updateZone(worldPlayer, startEntity.method_5628(), setPositions[0], setPositions[1], name, 0);
                    }
                    Logger.logSuccess((class_1657)serverPlayerEntity, "Creating start zone from " + setPositions[0].method_23854() + " to " + setPositions[1].method_23854());
                } else {
                    Logger.logFailure((class_1657)serverPlayerEntity, "You haven't set both corner positions.");
                }
            } else {
                Logger.logFailure((class_1657)serverPlayerEntity, "Not holding bounds stick");
            }
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "There is no map called " + name + ".");
        }
    }

    private static void handleAddEnd(CommandContext<class_2168> context) {
        class_3222 serverPlayerEntity = ((class_2168)context.getSource()).method_44023();
        String name = StringArgumentType.getString(context, (String)"map_name");
        DataManager.MapData pairedMap = DataManager.getMap(name);
        if (pairedMap != null) {
            class_3218 serverWorld = ((class_2168)context.getSource()).method_9225();
            if (BoundsStickItem.playerPositions.containsKey(serverPlayerEntity.method_5820())) {
                class_2338[] setPositions = BoundsStickItem.playerPositions.get(serverPlayerEntity.method_5820());
                if (setPositions[0] != null && setPositions[1] != null) {
                    EndEntity endEntity = (EndEntity)ModEntities.END_ENTITY.method_47821(serverWorld, setPositions[0], class_3730.field_16459);
                    endEntity.setCorner1(setPositions[0]);
                    endEntity.setCorner2(setPositions[1]);
                    endEntity.setPairedMap(name);
                    for (class_3222 worldPlayer : serverWorld.method_18456()) {
                        PacketHandler.updateZone(worldPlayer, endEntity.method_5628(), setPositions[0], setPositions[1], name, 0);
                    }
                    Logger.logSuccess((class_1657)serverPlayerEntity, "Creating end zone from " + setPositions[0].method_23854() + " to " + setPositions[1].method_23854());
                } else {
                    Logger.logFailure((class_1657)serverPlayerEntity, "You haven't set both corner positions.");
                }
            } else {
                Logger.logFailure((class_1657)serverPlayerEntity, "You need to set positions first.");
            }
        } else {
            Logger.logFailure((class_1657)serverPlayerEntity, "There is no map called " + name + ".");
        }
    }
}

