/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.data;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.nerdorg.minehop.Minehop;

public class DataManager {
    private static final Type mapListType = new TypeToken<List<MapData>>(){}.getType();
    private static final Type recordListType = new TypeToken<List<RecordData>>(){}.getType();
    private static final String folderName = "MineHop_Data";
    public static final String mapListLocation = "MineHop_Data/minehop_maps.json";
    public static final String pbListLocation = "MineHop_Data/minehop_pbs.json";
    public static final String recordsListLocation = "MineHop_Data/minehop_records.json";

    public static void register() {
        ServerWorldEvents.LOAD.register((server, world) -> {
            Minehop.mapList = new ArrayList<MapData>();
            Minehop.recordList = new ArrayList<RecordData>();
            Minehop.personalRecordList = new ArrayList<RecordData>();
            List newMapList = DataManager.loadData(world, mapListLocation, mapListType);
            List newPersonalRecordList = DataManager.loadData(world, pbListLocation, recordListType);
            List newRecordList = DataManager.loadData(world, recordsListLocation, recordListType);
            if (newMapList != null) {
                Minehop.mapList = newMapList;
            }
            if (newPersonalRecordList != null) {
                Minehop.personalRecordList = newPersonalRecordList;
            }
            if (newRecordList != null) {
                Minehop.recordList = newRecordList;
            }
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            DataManager.saveData(world, mapListLocation, Minehop.mapList);
            DataManager.saveData(world, pbListLocation, Minehop.personalRecordList);
            DataManager.saveData(world, recordsListLocation, Minehop.recordList);
        });
    }

    public static RecordData removePersonalRecordsForPlayer(String mapName, String playerName) {
        if (Minehop.personalRecordList != null) {
            for (RecordData recordData : Minehop.personalRecordList) {
                if (!recordData.map_name.equals(mapName) || !recordData.name.equals(playerName)) continue;
                Minehop.personalRecordList.remove(recordData);
                return recordData;
            }
        }
        return null;
    }

    public static RecordData removeRecordsForPlayer(String mapName, String playerName) {
        if (Minehop.recordList != null) {
            for (RecordData recordData : Minehop.recordList) {
                if (!recordData.map_name.equals(mapName) || !recordData.name.equals(playerName)) continue;
                Minehop.recordList.remove(recordData);
                double lowestTime = Double.MAX_VALUE;
                RecordData recordToAdd = null;
                for (RecordData newRecordData : Minehop.recordList) {
                    if (!newRecordData.map_name.equals(mapName) || !(newRecordData.time < lowestTime)) continue;
                    lowestTime = newRecordData.time;
                    recordToAdd = newRecordData;
                }
                if (recordToAdd != null) {
                    Minehop.recordList.add(recordToAdd);
                }
                return recordData;
            }
        }
        return null;
    }

    public static RecordData removePersonalRecords(String mapName) {
        if (Minehop.personalRecordList != null) {
            for (RecordData recordData : Minehop.personalRecordList) {
                if (!recordData.map_name.equals(mapName)) continue;
                Minehop.personalRecordList.remove(recordData);
                return recordData;
            }
        }
        return null;
    }

    public static RecordData removeRecords(String mapName) {
        if (Minehop.recordList != null) {
            for (RecordData recordData : Minehop.recordList) {
                if (!recordData.map_name.equals(mapName)) continue;
                Minehop.recordList.remove(recordData);
                return recordData;
            }
        }
        return null;
    }

    public static RecordData getPersonalRecord(String playerName, String mapName) {
        if (Minehop.personalRecordList != null) {
            for (RecordData recordData : Minehop.personalRecordList) {
                if (!recordData.name.equals(playerName) || !recordData.map_name.equals(mapName)) continue;
                return recordData;
            }
        }
        return null;
    }

    public static RecordData getRecord(String mapName) {
        if (Minehop.recordList != null) {
            for (RecordData recordData : Minehop.recordList) {
                if (!recordData.map_name.equals(mapName)) continue;
                return recordData;
            }
        }
        return null;
    }

    public static RecordData getRecordFromName(String mapName, String playerName) {
        if (Minehop.recordList != null) {
            for (RecordData recordData : Minehop.recordList) {
                if (!recordData.name.equals(playerName) || !recordData.map_name.equals(mapName)) continue;
                return recordData;
            }
        }
        return null;
    }

    public static RecordData getAnyRecordFromName(String playerName) {
        if (Minehop.recordList != null) {
            for (RecordData recordData : Minehop.recordList) {
                if (!recordData.name.equals(playerName)) continue;
                return recordData;
            }
        }
        return null;
    }

    public static MapData getMap(String mapName) {
        if (Minehop.mapList != null) {
            for (MapData mapData : Minehop.mapList) {
                if (!mapData.name.equals(mapName)) continue;
                return mapData;
            }
        }
        return null;
    }

    public static void resetPlayerCounts() {
        if (Minehop.mapList != null) {
            ArrayList<MapData> newMapList = new ArrayList<MapData>();
            for (MapData mapData : Minehop.mapList) {
                mapData.player_count = 0;
                newMapList.add(mapData);
            }
            Minehop.mapList = newMapList;
        }
    }

    public static <T> void saveData(class_3218 world, String location, List<T> data) {
        Gson gson = new Gson();
        String jsonData = gson.toJson(data);
        MinecraftServer server = world.method_8503();
        Path worldDir = server.method_27050(class_5218.field_24188);
        DataManager.folderCheck(worldDir);
        try {
            Files.write(worldDir.resolve(location), jsonData.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> List<T> loadData(class_3218 world, String location, Type recordListType) {
        Path worldDir = world.method_8503().method_27050(class_5218.field_24188);
        DataManager.folderCheck(worldDir);
        try {
            String jsonData = new String(Files.readAllBytes(worldDir.resolve(location)));
            Gson gson = new Gson();
            return (List)gson.fromJson(jsonData, recordListType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void folderCheck(Path path) {
        Path folderPath = Paths.get(folderName, new String[0]);
        try {
            Files.createDirectories(path.resolve(folderPath), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static class RecordData {
        public String name;
        public String map_name;
        public double time;

        public RecordData() {
        }

        public RecordData(String name, String map_name, double time) {
            this.name = name;
            this.map_name = map_name;
            this.time = time;
        }
    }

    public static class MapData {
        public String name;
        public double x;
        public double y;
        public double z;
        public double xrot;
        public double yrot;
        public String worldKey;
        public List<List<class_243>> checkpointPositions;
        public boolean arena;
        public boolean hns;
        public int difficulty;
        public int player_count;

        public MapData() {
        }

        public MapData(String name, double x, double y, double z, double xrot, double yrot, String worldKey) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
            this.xrot = xrot;
            this.yrot = yrot;
            this.worldKey = worldKey;
        }

        public MapData(String name, double x, double y, double z, double xrot, double yrot, String worldKey, boolean arena, boolean hns, int difficulty, int player_count) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
            this.xrot = xrot;
            this.yrot = yrot;
            this.worldKey = worldKey;
            this.arena = arena;
            this.hns = hns;
            this.difficulty = difficulty;
            this.player_count = player_count;
        }
    }
}

