/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.hns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.nerdorg.minehop.Minehop;
import net.nerdorg.minehop.data.DataManager;
import net.nerdorg.minehop.util.Logger;
import net.nerdorg.minehop.util.ZoneUtil;

public class HNSManager {
    public static HashMap<String, Boolean> taggedMap = new HashMap();
    public static HashMap<String, Boolean> mapHasTaggers = new HashMap();
    public static HashMap<String, Integer> mapTimers = new HashMap();
    private static final Random random = new Random();

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            HNSManager.handleMapTimers(server);
            HNSManager.resetMapHasTaggers();
            for (class_3222 playerEntity : server.method_3760().method_14571()) {
                if (!taggedMap.containsKey(playerEntity.method_5820())) {
                    taggedMap.put(playerEntity.method_5820(), false);
                    playerEntity.method_5834(false);
                    continue;
                }
                DataManager.MapData mapData = ZoneUtil.getCurrentMap((class_1297)playerEntity);
                if (taggedMap.get(playerEntity.method_5820()).booleanValue() && mapData != null && !mapData.hns) {
                    taggedMap.put(playerEntity.method_5820(), false);
                }
                if (mapData != null) {
                    boolean isTagged = taggedMap.get(playerEntity.method_5820());
                    if (isTagged) {
                        mapHasTaggers.put(mapData.name, true);
                        playerEntity.method_5834(true);
                        continue;
                    }
                    playerEntity.method_5834(false);
                    continue;
                }
                playerEntity.method_5834(false);
            }
            HNSManager.addTaggerIfNonePresent(server);
        });
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((livingEntity, damageSource, amount) -> {
            boolean sourceIsTagged;
            class_1657 sourcePlayer;
            class_1297 sourceEntity;
            class_1657 player;
            DataManager.MapData mapData;
            if (livingEntity instanceof class_1657 && (mapData = ZoneUtil.getCurrentMap((class_1297)(player = (class_1657)livingEntity))) != null && mapData.hns && (sourceEntity = damageSource.method_5526()) != null && sourceEntity instanceof class_1657 && !(sourcePlayer = (class_1657)sourceEntity).method_7337() && !sourcePlayer.method_7325() && taggedMap.containsKey(sourcePlayer.method_5820()) && (sourceIsTagged = taggedMap.get(sourcePlayer.method_5820()).booleanValue())) {
                Logger.logFailure(player, "You were tagged by " + sourcePlayer.method_5820());
                Logger.logSuccess(sourcePlayer, "You tagged " + player.method_5820());
                taggedMap.put(player.method_5820(), true);
            }
            return true;
        });
    }

    private static void resetMapHasTaggers() {
        for (DataManager.MapData mapData : Minehop.mapList) {
            if (!mapData.hns) continue;
            mapHasTaggers.put(mapData.name, false);
        }
    }

    private static void handleMapTimers(MinecraftServer server) {
        for (DataManager.MapData mapData : Minehop.mapList) {
            if (!mapData.hns || HNSManager.resetIfAllTagged(mapData.name, server)) continue;
            if (mapHasTaggers.containsKey(mapData.name) && !mapHasTaggers.get(mapData.name).booleanValue()) {
                mapTimers.put(mapData.name, server.method_3780());
            }
            if (!mapTimers.containsKey(mapData.name)) continue;
            int startTime = mapTimers.get(mapData.name);
            if (server.method_3780() >= startTime + 3600) {
                HNSManager.removeAllTaggersAndReset(mapData.name, server);
                mapTimers.put(mapData.name, server.method_3780());
                continue;
            }
            int timeDif = server.method_3780() - startTime;
            if (timeDif % 1200 != 0) continue;
            HNSManager.logToAllParticipants(mapData.name, server, (3600 - timeDif) / 20 / 60 + " Minutes remaining in HNS round.");
        }
    }

    private static void addTaggerIfNonePresent(MinecraftServer server) {
        for (DataManager.MapData mapData : Minehop.mapList) {
            boolean hasTaggers;
            if (!mapData.hns || !mapHasTaggers.containsKey(mapData.name) || (hasTaggers = mapHasTaggers.get(mapData.name).booleanValue())) continue;
            HNSManager.assignRandomTagger(mapData.name, server);
        }
    }

    private static void logToAllParticipants(String mapName, MinecraftServer server, String message) {
        for (class_3222 playerEntity : server.method_3760().method_14571()) {
            DataManager.MapData mapData = ZoneUtil.getCurrentMap((class_1297)playerEntity);
            if (mapData == null || !mapData.name.equals(mapName)) continue;
            Logger.logSuccess((class_1657)playerEntity, message);
        }
    }

    private static void assignRandomTagger(String mapName, MinecraftServer server) {
        ArrayList<class_3222> playersOnMap = new ArrayList<class_3222>();
        for (class_3222 playerEntity : server.method_3760().method_14571()) {
            DataManager.MapData mapData = ZoneUtil.getCurrentMap((class_1297)playerEntity);
            if (mapData == null || !mapData.name.equals(mapName)) continue;
            playersOnMap.add(playerEntity);
        }
        if (!playersOnMap.isEmpty()) {
            class_3222 randomPlayer = (class_3222)playersOnMap.get(random.nextInt(playersOnMap.size()));
            Logger.logFailure((class_1657)randomPlayer, "You were randomly selected to be tagged because nobody was tagged.");
            taggedMap.put(randomPlayer.method_5820(), true);
        }
    }

    private static boolean resetIfAllTagged(String mapName, MinecraftServer server) {
        boolean allTagged = true;
        int players = 0;
        for (class_3222 playerEntity : server.method_3760().method_14571()) {
            boolean tagged;
            DataManager.MapData mapData = ZoneUtil.getCurrentMap((class_1297)playerEntity);
            if (mapData == null || !mapData.name.equals(mapName)) continue;
            ++players;
            if (!taggedMap.containsKey(playerEntity.method_5820()) || (tagged = taggedMap.get(playerEntity.method_5820()).booleanValue())) continue;
            allTagged = false;
            break;
        }
        if (allTagged && players > 1) {
            HNSManager.removeAllTaggersAndReset(mapName, server);
            return true;
        }
        return false;
    }

    private static void removeAllTaggers(String mapName, MinecraftServer server) {
        for (class_3222 playerEntity : server.method_3760().method_14571()) {
            DataManager.MapData mapData = ZoneUtil.getCurrentMap((class_1297)playerEntity);
            if (mapData == null || !mapData.name.equals(mapName)) continue;
            taggedMap.remove(playerEntity.method_5820());
        }
    }

    private static void removeAllTaggersAndReset(String mapName, MinecraftServer server) {
        for (class_3222 playerEntity : server.method_3760().method_14571()) {
            DataManager.MapData mapData = ZoneUtil.getCurrentMap((class_1297)playerEntity);
            if (mapData == null || !mapData.name.equals(mapName)) continue;
            class_3218 foundWorld = null;
            for (class_3218 serverWorld : server.method_3738()) {
                if (!serverWorld.method_27983().toString().equals(mapData.worldKey)) continue;
                foundWorld = serverWorld;
                break;
            }
            if (foundWorld != null) {
                ArrayList<class_243> spawnCheck = new ArrayList<class_243>();
                spawnCheck.add(new class_243(mapData.x, mapData.y, mapData.z));
                spawnCheck.add(new class_243(mapData.xrot, mapData.yrot, 0.0));
                ArrayList<List<class_243>> checkpointPositions = new ArrayList<List<class_243>>();
                if (mapData.checkpointPositions != null) {
                    checkpointPositions.addAll(mapData.checkpointPositions);
                }
                checkpointPositions.add(spawnCheck);
                List randomCheckpoint = (List)checkpointPositions.get(random.nextInt(0, checkpointPositions.size()));
                class_243 targetPos = (class_243)randomCheckpoint.get(0);
                class_243 rotPos = (class_243)randomCheckpoint.get(1);
                boolean tagged = false;
                if (taggedMap.containsKey(playerEntity.method_5820())) {
                    tagged = taggedMap.get(playerEntity.method_5820());
                }
                Logger.logSuccess((class_1657)playerEntity, "HNS round over, " + (tagged ? "you got tagged :(" : "you survived as a hider!"));
                playerEntity.method_48105(foundWorld, targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215(), class_2709.field_40710, (float)rotPos.method_10214(), (float)rotPos.method_10216());
            }
            taggedMap.remove(playerEntity.method_5820());
        }
    }
}

