/*
 * Decompiled with CFR 0.152.
 */
package net.nerdorg.minehop.networking;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.nerdorg.minehop.Minehop;
import net.nerdorg.minehop.MinehopClient;
import net.nerdorg.minehop.anticheat.ProcessChecker;
import net.nerdorg.minehop.block.entity.BoostBlockEntity;
import net.nerdorg.minehop.data.DataManager;
import net.nerdorg.minehop.entity.client.CustomPlayerEntityRenderer;
import net.nerdorg.minehop.entity.custom.EndEntity;
import net.nerdorg.minehop.entity.custom.ResetEntity;
import net.nerdorg.minehop.entity.custom.StartEntity;
import net.nerdorg.minehop.networking.ModMessages;
import net.nerdorg.minehop.screen.SelectMapScreen;

@Environment(value=EnvType.CLIENT)
public class ClientPacketHandler {
    public static void sortMapList(List<DataManager.MapData> mapList) {
        Collections.sort(mapList, new Comparator<DataManager.MapData>(){

            @Override
            public int compare(DataManager.MapData m1, DataManager.MapData m2) {
                return m1.name.compareToIgnoreCase(m2.name);
            }
        });
    }

    public static void registerReceivers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.CONFIG_SYNC_ID, (client, handler, buf, responseSender) -> {
            double o_sv_friction = buf.readDouble();
            double o_sv_accelerate = buf.readDouble();
            double o_sv_airaccelerate = buf.readDouble();
            double o_sv_maxairspeed = buf.readDouble();
            double o_speed_mul = buf.readDouble();
            double o_sv_gravity = buf.readDouble();
            double o_speed_cap = buf.readDouble();
            boolean o_hns = buf.readBoolean();
            client.execute(() -> {
                Minehop.o_sv_friction = o_sv_friction;
                Minehop.o_sv_accelerate = o_sv_accelerate;
                Minehop.o_sv_airaccelerate = o_sv_airaccelerate;
                Minehop.o_sv_maxairspeed = o_sv_maxairspeed;
                Minehop.o_speed_mul = o_speed_mul;
                Minehop.o_sv_gravity = o_sv_gravity;
                Minehop.o_speed_cap = o_speed_cap;
                Minehop.o_hns = o_hns;
                Minehop.receivedConfig = true;
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.ZONE_SYNC_ID, (client, handler, buf, responseSender) -> {
            int entity_id = buf.readInt();
            class_2338 pos1 = buf.method_10811();
            class_2338 pos2 = buf.method_10811();
            String name = buf.method_19772();
            int check_index = buf.readInt();
            client.execute(() -> {
                class_1297 entity = client.field_1687.method_8469(entity_id);
                if (entity instanceof ResetEntity) {
                    ResetEntity resetEntity = (ResetEntity)entity;
                    resetEntity.setCorner1(pos1);
                    resetEntity.setCorner2(pos2);
                    resetEntity.setPairedMap(name);
                    resetEntity.setCheckIndex(check_index);
                } else if (entity instanceof StartEntity) {
                    StartEntity startEntity = (StartEntity)entity;
                    startEntity.setCorner1(pos1);
                    startEntity.setCorner2(pos2);
                    startEntity.setPairedMap(name);
                } else if (entity instanceof EndEntity) {
                    EndEntity endEntity = (EndEntity)entity;
                    endEntity.setCorner1(pos1);
                    endEntity.setCorner2(pos2);
                    endEntity.setPairedMap(name);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.SELF_V_TOGGLE, (client, handler, buf, responseSender) -> client.execute(() -> {
            MinehopClient.hideSelf = !MinehopClient.hideSelf;
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.OTHER_V_TOGGLE, (client, handler, buf, responseSender) -> client.execute(() -> {
            MinehopClient.hideOthers = !MinehopClient.hideOthers;
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.REPLAY_V_TOGGLE, (client, handler, buf, responseSender) -> client.execute(() -> {
            MinehopClient.hideReplay = !MinehopClient.hideReplay;
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.SEND_SPECTATORS, (client, handler, buf, responseSender) -> client.execute(() -> {
            ArrayList<String> newSpectatorList = new ArrayList<String>();
            int stringCount = buf.readInt();
            for (int i = 0; i < stringCount; ++i) {
                String spectatorName = buf.method_19772();
                newSpectatorList.add(spectatorName);
            }
            MinehopClient.spectatorList = newSpectatorList;
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.SEND_EFFICIENCY, (client, handler, buf, responseSender) -> {
            double efficiency = buf.readDouble();
            client.execute(() -> {
                List<Double> efficiencyList;
                if (efficiency != 0.0) {
                    MinehopClient.last_efficiency = efficiency;
                } else if (Minehop.efficiencyListMap.containsKey(client.field_1724.method_5820()) && (efficiencyList = Minehop.efficiencyListMap.get(client.field_1724.method_5820())) != null && efficiencyList.size() > 1) {
                    double averageEfficiency;
                    MinehopClient.last_efficiency = averageEfficiency = efficiencyList.stream().mapToDouble(Double::doubleValue).average().orElse(Double.NaN);
                    Minehop.efficiencyListMap.put(client.field_1724.method_5820(), new ArrayList());
                }
                ClientPacketHandler.sendSpecEfficiency();
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.CLIENT_SPEC_EFFICIENCY, (client, handler, buf, responseSender) -> {
            double last_jump_speed = buf.readDouble();
            int jump_count = buf.readInt();
            double last_efficiency = buf.readDouble();
            client.execute(() -> {
                MinehopClient.last_jump_speed = last_jump_speed;
                MinehopClient.jump_count = jump_count;
                MinehopClient.last_efficiency = last_efficiency;
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.OPEN_MAP_SCREEN, (client, handler, buf, responseSender) -> {
            String title = buf.method_19772();
            client.execute(() -> client.method_1507((class_437)new SelectMapScreen((class_2561)class_2561.method_43470((String)title))));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.SEND_RECORDS, (client, handler, buf, responseSender) -> {
            ArrayList<DataManager.RecordData> newRecordList = new ArrayList<DataManager.RecordData>();
            int recordCount = buf.readInt();
            for (int i = 0; i < recordCount; ++i) {
                String map_name = buf.method_19772();
                String name = buf.method_19772();
                double time = buf.readDouble();
                if (!(time > 0.0)) continue;
                newRecordList.add(new DataManager.RecordData(name, map_name, time));
            }
            client.execute(() -> {
                Minehop.recordList = newRecordList;
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.SEND_MAPS, (client, handler, buf, responseSender) -> {
            ArrayList<DataManager.MapData> newMapList = new ArrayList<DataManager.MapData>();
            int recordCount = buf.readInt();
            for (int i = 0; i < recordCount; ++i) {
                String name = buf.method_19772();
                double x = buf.readDouble();
                double y = buf.readDouble();
                double z = buf.readDouble();
                double xrot = buf.readDouble();
                double yrot = buf.readDouble();
                String worldKey = buf.method_19772();
                boolean arena = buf.readBoolean();
                boolean hns = buf.readBoolean();
                int difficulty = buf.readInt();
                int player_count = buf.readInt();
                newMapList.add(new DataManager.MapData(name, x, y, z, xrot, yrot, worldKey, arena, hns, difficulty, player_count));
            }
            client.execute(() -> {
                Minehop.mapList = newMapList;
                ClientPacketHandler.sortMapList(Minehop.mapList);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.SEND_PERSONAL_RECORDS, (client, handler, buf, responseSender) -> {
            ArrayList<DataManager.RecordData> newRecordList = new ArrayList<DataManager.RecordData>();
            int recordCount = buf.readInt();
            for (int i = 0; i < recordCount; ++i) {
                String map_name = buf.method_19772();
                String name = buf.method_19772();
                double time = buf.readDouble();
                if (!(time > 0.0)) continue;
                newRecordList.add(new DataManager.RecordData(name, map_name, time));
            }
            client.execute(() -> {
                Minehop.personalRecordList = newRecordList;
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.UPDATE_POWER, (client, handler, buf, responseSender) -> {
            double power_x = buf.readDouble();
            double power_y = buf.readDouble();
            double power_z = buf.readDouble();
            class_2338 boosterPos = new class_2338(buf.readInt(), buf.readInt(), buf.readInt());
            client.execute(() -> new Thread(() -> {
                class_2586 blockEntity = client.field_1724.method_37908().method_8321(boosterPos);
                if (blockEntity instanceof BoostBlockEntity) {
                    BoostBlockEntity boostBlockEntity = (BoostBlockEntity)blockEntity;
                    boostBlockEntity.setXPower(power_x);
                    boostBlockEntity.setYPower(power_y);
                    boostBlockEntity.setZPower(power_z);
                }
            }).start());
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.ANTI_CHEAT_CHECK, (client, handler, buf, responseSender) -> client.execute(() -> new Thread(() -> {
            String[] softwareNames = buf.method_19772().split("~");
            softwareNames = Arrays.copyOfRange(softwareNames, 1, softwareNames.length);
            byte[] checkResults = new byte[softwareNames.length];
            for (int i = 0; i < softwareNames.length; ++i) {
                checkResults[i] = ProcessChecker.isProcessRunningByte(softwareNames[i]);
            }
            ClientPacketHandler.sendAntiCheatCheck(checkResults);
        }).start()));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModMessages.SET_PLAYER_CHEATER, (client, handler, buf, responseSender) -> client.execute(() -> new Thread(() -> {
            String UUID2 = buf.method_19772();
            boolean isCheater = buf.readBoolean();
            if (isCheater) {
                CustomPlayerEntityRenderer.setPlayerModel(CustomPlayerEntityRenderer.PlayerModel.Cheater, UUID2);
            } else {
                CustomPlayerEntityRenderer.setPlayerModel(CustomPlayerEntityRenderer.PlayerModel.Player, UUID2);
            }
        }).start()));
    }

    public static void sendHandshake() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(1013);
        ClientPlayNetworking.send((class_2960)ModMessages.HANDSHAKE_ID, (class_2540)buf);
    }

    public static void sendSpecEfficiency() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeDouble(MinehopClient.last_jump_speed);
        buf.writeInt(MinehopClient.jump_count);
        buf.writeDouble(MinehopClient.last_efficiency);
        ClientPlayNetworking.send((class_2960)ModMessages.SERVER_SPEC_EFFICIENCY, (class_2540)buf);
    }

    public static void sendAntiCheatCheck(byte[] checkResults) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10813(checkResults);
        ClientPlayNetworking.send((class_2960)ModMessages.ANTI_CHEAT_CHECK, (class_2540)buf);
    }

    public static void sendEndMapEvent(float time) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeFloat(time);
        ClientPlayNetworking.send((class_2960)ModMessages.MAP_FINISH, (class_2540)buf);
    }

    public static void sendCurrentTime(float time) {
        if ((double)time > (double)MinehopClient.lastSendTime + 0.01) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeFloat(time);
            ClientPlayNetworking.send((class_2960)ModMessages.SEND_TIME, (class_2540)buf);
            MinehopClient.lastSendTime = time;
        }
    }
}

